/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;

public class SimpleLocationOverlay
extends Overlay {
    protected final Paint mPaint = new Paint();
    protected final Bitmap PERSON_ICON;
    protected final Point PERSON_HOTSPOT = new Point(24, 39);
    protected GeoPoint mLocation;
    private final Point screenCoords = new Point();

    public SimpleLocationOverlay(Context ctx) {
        this(ctx, new DefaultResourceProxyImpl(ctx));
    }

    public SimpleLocationOverlay(Context ctx, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        this.PERSON_ICON = this.mResourceProxy.getBitmap(ResourceProxy.bitmap.person);
    }

    public void setLocation(GeoPoint mp) {
        this.mLocation = mp;
    }

    public GeoPoint getMyLocation() {
        return this.mLocation;
    }

    @Override
    public void draw(Canvas c, MapView osmv, boolean shadow) {
        if (!shadow && this.mLocation != null) {
            Projection pj = osmv.getProjection();
            pj.toPixels(this.mLocation, this.screenCoords);
            c.drawBitmap(this.PERSON_ICON, (float)(this.screenCoords.x - this.PERSON_HOTSPOT.x), (float)(this.screenCoords.y - this.PERSON_HOTSPOT.y), this.mPaint);
        }
    }
}

