/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.drawing;

import android.graphics.Path;
import android.graphics.Point;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.Projection;

public class OsmPath
extends Path {
    private static final GeoPoint sReferenceGeoPoint = new GeoPoint(0, 0);
    protected final Point mReferencePoint = new Point();
    private int mLastZoomLevel = -1;

    public OsmPath() {
    }

    public OsmPath(Path src) {
        super(src);
    }

    public void onDrawCycle(Projection proj) {
        if (this.mLastZoomLevel != proj.getZoomLevel()) {
            proj.toPixels(sReferenceGeoPoint, this.mReferencePoint);
            this.mLastZoomLevel = proj.getZoomLevel();
        } else {
            int x = this.mReferencePoint.x;
            int y = this.mReferencePoint.y;
            proj.toPixels(sReferenceGeoPoint, this.mReferencePoint);
            int deltaX = this.mReferencePoint.x - x;
            int deltaY = this.mReferencePoint.y - y;
            this.offset(deltaX, deltaY);
        }
    }
}

