/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.compass;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.FloatMath;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.WindowManager;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.SafeDrawOverlay;
import org.osmdroid.views.overlay.compass.IOrientationConsumer;
import org.osmdroid.views.overlay.compass.IOrientationProvider;
import org.osmdroid.views.overlay.compass.InternalCompassOrientationProvider;
import org.osmdroid.views.safecanvas.ISafeCanvas;
import org.osmdroid.views.safecanvas.SafePaint;

public class CompassOverlay
extends SafeDrawOverlay
implements IOverlayMenuProvider,
IOrientationConsumer {
    protected final MapView mMapView;
    private final Display mDisplay;
    public IOrientationProvider mOrientationProvider;
    protected final SafePaint mPaint = new SafePaint();
    protected final Picture mCompassFrame = new Picture();
    protected final Picture mCompassRose = new Picture();
    private final Matrix mCompassMatrix = new Matrix();
    private boolean mIsCompassEnabled;
    private float mAzimuth = Float.NaN;
    private float mCompassCenterX = 35.0f;
    private float mCompassCenterY = 35.0f;
    private final float mCompassRadius = 20.0f;
    protected final float mCompassFrameCenterX;
    protected final float mCompassFrameCenterY;
    protected final float mCompassRoseCenterX;
    protected final float mCompassRoseCenterY;
    public static final int MENU_COMPASS = CompassOverlay.getSafeMenuId();
    private boolean mOptionsMenuEnabled = true;

    public CompassOverlay(Context context, MapView mapView) {
        this(context, new InternalCompassOrientationProvider(context), mapView);
    }

    public CompassOverlay(Context context, IOrientationProvider orientationProvider, MapView mapView) {
        this(context, orientationProvider, mapView, new DefaultResourceProxyImpl(context));
    }

    public CompassOverlay(Context context, IOrientationProvider orientationProvider, MapView mapView, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        this.mMapView = mapView;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.mDisplay = windowManager.getDefaultDisplay();
        this.createCompassFramePicture();
        this.createCompassRosePicture();
        this.mCompassFrameCenterX = (float)(this.mCompassFrame.getWidth() / 2) - 0.5f;
        this.mCompassFrameCenterY = (float)(this.mCompassFrame.getHeight() / 2) - 0.5f;
        this.mCompassRoseCenterX = (float)(this.mCompassRose.getWidth() / 2) - 0.5f;
        this.mCompassRoseCenterY = (float)(this.mCompassRose.getHeight() / 2) - 0.5f;
        this.setOrientationProvider(orientationProvider);
    }

    @Override
    public void onDetach(MapView mapView) {
        this.disableCompass();
        super.onDetach(mapView);
    }

    private void invalidateCompass() {
        Rect screenRect = this.mMapView.getProjection().getScreenRect();
        int frameLeft = screenRect.left + this.mMapView.getWidth() / 2 + (int)FloatMath.ceil((float)((this.mCompassCenterX - this.mCompassFrameCenterX) * this.mScale));
        int frameTop = screenRect.top + this.mMapView.getHeight() / 2 + (int)FloatMath.ceil((float)((this.mCompassCenterY - this.mCompassFrameCenterY) * this.mScale));
        int frameRight = screenRect.left + this.mMapView.getWidth() / 2 + (int)FloatMath.ceil((float)((this.mCompassCenterX + this.mCompassFrameCenterX) * this.mScale));
        int frameBottom = screenRect.top + this.mMapView.getHeight() / 2 + (int)FloatMath.ceil((float)((this.mCompassCenterY + this.mCompassFrameCenterY) * this.mScale));
        this.mMapView.postInvalidate(frameLeft - 2, frameTop - 2, frameRight + 2, frameBottom + 2);
    }

    public void setCompassCenter(float x, float y) {
        this.mCompassCenterX = x;
        this.mCompassCenterY = y;
    }

    public IOrientationProvider getOrientationProvider() {
        return this.mOrientationProvider;
    }

    protected void setOrientationProvider(IOrientationProvider orientationProvider) {
        if (orientationProvider == null) {
            throw new RuntimeException("You must pass an IOrientationProvider to setOrientationProvider()");
        }
        if (this.mOrientationProvider != null) {
            this.mOrientationProvider.stopOrientationProvider();
        }
        this.mOrientationProvider = orientationProvider;
    }

    protected void drawCompass(ISafeCanvas canvas, float bearing, Rect screenRect) {
        float centerX = this.mCompassCenterX * this.mScale;
        float centerY = this.mCompassCenterY * this.mScale + (float)(canvas.getHeight() - this.mMapView.getHeight());
        this.mCompassMatrix.setTranslate(-this.mCompassFrameCenterX, -this.mCompassFrameCenterY);
        this.mCompassMatrix.postTranslate(centerX, centerY);
        canvas.save();
        canvas.setMatrix(this.mCompassMatrix);
        canvas.drawPicture(this.mCompassFrame);
        this.mCompassMatrix.setRotate(-bearing, this.mCompassRoseCenterX, this.mCompassRoseCenterY);
        this.mCompassMatrix.postTranslate(-this.mCompassRoseCenterX, -this.mCompassRoseCenterY);
        this.mCompassMatrix.postTranslate(centerX, centerY);
        canvas.setMatrix(this.mCompassMatrix);
        canvas.drawPicture(this.mCompassRose);
        canvas.restore();
    }

    @Override
    protected void drawSafe(ISafeCanvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.isCompassEnabled() && !Float.isNaN(this.mAzimuth)) {
            this.drawCompass(canvas, this.mAzimuth + (float)this.getDisplayOrientation(), mapView.getProjection().getScreenRect());
        }
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.add(0, MENU_COMPASS + pMenuIdOffset, 0, (CharSequence)this.mResourceProxy.getString(ResourceProxy.string.compass)).setIcon(this.mResourceProxy.getDrawable(ResourceProxy.bitmap.ic_menu_compass)).setCheckable(true);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.findItem(MENU_COMPASS + pMenuIdOffset).setChecked(this.isCompassEnabled());
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId == MENU_COMPASS) {
            if (this.isCompassEnabled()) {
                this.disableCompass();
            } else {
                this.enableCompass();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onOrientationChanged(float orientation, IOrientationProvider source) {
        this.mAzimuth = orientation;
        this.invalidateCompass();
    }

    public boolean enableCompass(IOrientationProvider orientationProvider) {
        this.setOrientationProvider(orientationProvider);
        this.mIsCompassEnabled = false;
        return this.enableCompass();
    }

    public boolean enableCompass() {
        boolean result = true;
        if (this.mIsCompassEnabled) {
            this.mOrientationProvider.stopOrientationProvider();
        }
        this.mIsCompassEnabled = result = this.mOrientationProvider.startOrientationProvider(this);
        if (this.mMapView != null) {
            this.invalidateCompass();
        }
        return result;
    }

    public void disableCompass() {
        this.mIsCompassEnabled = false;
        if (this.mOrientationProvider != null) {
            this.mOrientationProvider.stopOrientationProvider();
        }
        this.mAzimuth = Float.NaN;
        if (this.mMapView != null) {
            this.invalidateCompass();
        }
    }

    public boolean isCompassEnabled() {
        return this.mIsCompassEnabled;
    }

    public float getOrientation() {
        return this.mAzimuth;
    }

    private Point calculatePointOnCircle(float centerX, float centerY, float radius, float degrees) {
        double dblRadians = Math.toRadians(-degrees + 90.0f);
        int intX = (int)((double)radius * Math.cos(dblRadians));
        int intY = (int)((double)radius * Math.sin(dblRadians));
        return new Point((int)centerX + intX, (int)centerY - intY);
    }

    private void drawTriangle(Canvas canvas, float x, float y, float radius, float degrees, Paint paint) {
        canvas.save();
        Point point = this.calculatePointOnCircle(x, y, radius, degrees);
        canvas.rotate(degrees, (float)point.x, (float)point.y);
        Path p = new Path();
        p.moveTo((float)point.x - 2.0f * this.mScale, (float)point.y);
        p.lineTo((float)point.x + 2.0f * this.mScale, (float)point.y);
        p.lineTo((float)point.x, (float)point.y - 5.0f * this.mScale);
        p.close();
        canvas.drawPath(p, paint);
        canvas.restore();
    }

    private int getDisplayOrientation() {
        switch (this.mDisplay.getOrientation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    private void createCompassFramePicture() {
        Paint innerPaint = new Paint();
        innerPaint.setColor(-1);
        innerPaint.setAntiAlias(true);
        innerPaint.setStyle(Paint.Style.FILL);
        innerPaint.setAlpha(200);
        Paint outerPaint = new Paint();
        outerPaint.setColor(-7829368);
        outerPaint.setAntiAlias(true);
        outerPaint.setStyle(Paint.Style.STROKE);
        outerPaint.setStrokeWidth(2.0f);
        outerPaint.setAlpha(200);
        int picBorderWidthAndHeight = 50;
        int center = 25;
        Canvas canvas = this.mCompassFrame.beginRecording(50, 50);
        canvas.drawCircle(25.0f, 25.0f, 20.0f * this.mScale, innerPaint);
        canvas.drawCircle(25.0f, 25.0f, 20.0f * this.mScale, outerPaint);
        this.drawTriangle(canvas, 25.0f, 25.0f, 20.0f * this.mScale, 0.0f, outerPaint);
        this.drawTriangle(canvas, 25.0f, 25.0f, 20.0f * this.mScale, 90.0f, outerPaint);
        this.drawTriangle(canvas, 25.0f, 25.0f, 20.0f * this.mScale, 180.0f, outerPaint);
        this.drawTriangle(canvas, 25.0f, 25.0f, 20.0f * this.mScale, 270.0f, outerPaint);
        this.mCompassFrame.endRecording();
    }

    private void createCompassRosePicture() {
        Paint northPaint = new Paint();
        northPaint.setColor(-6291456);
        northPaint.setAntiAlias(true);
        northPaint.setStyle(Paint.Style.FILL);
        northPaint.setAlpha(220);
        Paint southPaint = new Paint();
        southPaint.setColor(-16777216);
        southPaint.setAntiAlias(true);
        southPaint.setStyle(Paint.Style.FILL);
        southPaint.setAlpha(220);
        Paint centerPaint = new Paint();
        centerPaint.setColor(-1);
        centerPaint.setAntiAlias(true);
        centerPaint.setStyle(Paint.Style.FILL);
        centerPaint.setAlpha(220);
        int picBorderWidthAndHeight = 50;
        int center = 25;
        Canvas canvas = this.mCompassRose.beginRecording(50, 50);
        Path pathNorth = new Path();
        pathNorth.moveTo(25.0f, 25.0f - 17.0f * this.mScale);
        pathNorth.lineTo(25.0f + 4.0f * this.mScale, 25.0f);
        pathNorth.lineTo(25.0f - 4.0f * this.mScale, 25.0f);
        pathNorth.lineTo(25.0f, 25.0f - 17.0f * this.mScale);
        pathNorth.close();
        canvas.drawPath(pathNorth, northPaint);
        Path pathSouth = new Path();
        pathSouth.moveTo(25.0f, 25.0f + 17.0f * this.mScale);
        pathSouth.lineTo(25.0f + 4.0f * this.mScale, 25.0f);
        pathSouth.lineTo(25.0f - 4.0f * this.mScale, 25.0f);
        pathSouth.lineTo(25.0f, 25.0f + 17.0f * this.mScale);
        pathSouth.close();
        canvas.drawPath(pathSouth, southPaint);
        canvas.drawCircle(25.0f, 25.0f, 2.0f, centerPaint);
        this.mCompassRose.endRecording();
    }
}

