/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.location.Location;
import android.location.LocationManager;
import org.osmdroid.util.constants.UtilConstants;

public class LocationUtils
implements UtilConstants {
    private LocationUtils() {
    }

    public static Location getLastKnownLocation(LocationManager pLocationManager) {
        if (pLocationManager == null) {
            return null;
        }
        Location gpsLocation = LocationUtils.getLastKnownLocation(pLocationManager, "gps");
        Location networkLocation = LocationUtils.getLastKnownLocation(pLocationManager, "network");
        if (gpsLocation == null) {
            return networkLocation;
        }
        if (networkLocation == null) {
            return gpsLocation;
        }
        if (networkLocation.getTime() > gpsLocation.getTime() + 20000L) {
            return networkLocation;
        }
        return gpsLocation;
    }

    private static Location getLastKnownLocation(LocationManager pLocationManager, String pProvider) {
        if (!pLocationManager.isProviderEnabled(pProvider)) {
            return null;
        }
        return pLocationManager.getLastKnownLocation(pProvider);
    }
}

