/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.sqs;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;

public class AttributeHandler {
    public static Map<String, String> collectMetadataAttributes(Message message, String queueUrl) {
        String key;
        String originalKey;
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("queueUrl", queueUrl);
        for (Map.Entry entry : message.attributes().entrySet()) {
            originalKey = ((MessageSystemAttributeName)entry.getKey()).toString();
            key = originalKey.substring(0, 1).toLowerCase() + originalKey.substring(1);
            metadataMap.put(key, (String)entry.getValue());
        }
        for (Map.Entry entry : message.messageAttributes().entrySet()) {
            originalKey = ((String)entry.getKey()).toString();
            key = originalKey.substring(0, 1).toLowerCase() + originalKey.substring(1);
            metadataMap.put(key, ((MessageAttributeValue)entry.getValue()).stringValue());
        }
        return metadataMap;
    }

    public static void applyMetadataAttributes(Event event, Map<String, String> attributes) {
        EventMetadata metadata = event.getMetadata();
        attributes.forEach((arg_0, arg_1) -> ((EventMetadata)metadata).setAttribute(arg_0, arg_1));
    }
}

