/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.sqs;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.plugins.source.sqs.common.OnErrorOption;

public class QueueConfig {
    private static final Integer DEFAULT_MAXIMUM_MESSAGES = null;
    private static final boolean DEFAULT_VISIBILITY_DUPLICATE_PROTECTION = false;
    private static final Duration DEFAULT_VISIBILITY_TIMEOUT_SECONDS = null;
    private static final Duration DEFAULT_VISIBILITY_DUPLICATE_PROTECTION_TIMEOUT = Duration.ofHours(2L);
    private static final Duration DEFAULT_WAIT_TIME_SECONDS = null;
    private static final Duration DEFAULT_POLL_DELAY_SECONDS = Duration.ofSeconds(0L);
    static final int DEFAULT_NUMBER_OF_WORKERS = 1;
    @JsonProperty(value="url")
    @NotNull
    private String url;
    @JsonProperty(value="workers")
    @Valid
    private int numWorkers = 1;
    @JsonProperty(value="maximum_messages")
    @Min(value=1L)
    @Max(value=10L)
    private @Min(value=1L) @Max(value=10L) Integer maximumMessages = DEFAULT_MAXIMUM_MESSAGES;
    @JsonProperty(value="poll_delay")
    @DurationMin(seconds=0L)
    private @DurationMin(seconds=0L) Duration pollDelay = DEFAULT_POLL_DELAY_SECONDS;
    @JsonProperty(value="visibility_timeout")
    @DurationMin(seconds=0L)
    @DurationMax(seconds=43200L)
    private @DurationMin(seconds=0L) @DurationMax(seconds=43200L) Duration visibilityTimeout = DEFAULT_VISIBILITY_TIMEOUT_SECONDS;
    @JsonProperty(value="visibility_duplication_protection")
    @NotNull
    private boolean visibilityDuplicateProtection = false;
    @JsonProperty(value="visibility_duplicate_protection_timeout")
    @DurationMin(seconds=30L)
    @DurationMax(hours=24L)
    private @DurationMin(seconds=30L) @DurationMax(hours=24L) Duration visibilityDuplicateProtectionTimeout = DEFAULT_VISIBILITY_DUPLICATE_PROTECTION_TIMEOUT;
    @JsonProperty(value="wait_time")
    @DurationMin(seconds=0L)
    @DurationMax(seconds=20L)
    private @DurationMin(seconds=0L) @DurationMax(seconds=20L) Duration waitTime = DEFAULT_WAIT_TIME_SECONDS;
    @JsonProperty(value="codec")
    private PluginModel codec = null;
    @JsonProperty(value="on_error")
    private OnErrorOption onErrorOption = OnErrorOption.RETAIN_MESSAGES;

    public String getUrl() {
        return this.url;
    }

    public Integer getMaximumMessages() {
        return this.maximumMessages;
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public Duration getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public boolean getVisibilityDuplicateProtection() {
        return this.visibilityDuplicateProtection;
    }

    public Duration getVisibilityDuplicateProtectionTimeout() {
        return this.visibilityDuplicateProtectionTimeout;
    }

    public Duration getWaitTime() {
        return this.waitTime;
    }

    public Duration getPollDelay() {
        return this.pollDelay;
    }

    public PluginModel getCodec() {
        return this.codec;
    }

    public OnErrorOption getOnErrorOption() {
        return this.onErrorOption;
    }
}

