/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import java.time.Duration;
import java.time.Instant;
import org.apache.parquet.io.SeekableInputStream;
import org.opensearch.dataprepper.model.io.InputFile;
import org.opensearch.dataprepper.plugins.source.s3.S3InputStream;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectPluginMetrics;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectReference;
import org.opensearch.dataprepper.plugins.source.s3.ownership.BucketOwnerProvider;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;

public class S3InputFile
implements InputFile {
    private static final Duration DEFAULT_RETRY_DELAY = Duration.ofSeconds(6L);
    private static final int DEFAULT_RETRIES = 10;
    private final S3Client s3Client;
    private final S3ObjectReference s3ObjectReference;
    private final BucketOwnerProvider bucketOwnerProvider;
    private final S3ObjectPluginMetrics s3ObjectPluginMetrics;
    private HeadObjectResponse metadata;

    public S3InputFile(S3Client s3Client, S3ObjectReference s3ObjectReference, BucketOwnerProvider bucketOwnerProvider, S3ObjectPluginMetrics s3ObjectPluginMetrics) {
        this.s3Client = s3Client;
        this.s3ObjectReference = s3ObjectReference;
        this.bucketOwnerProvider = bucketOwnerProvider;
        this.s3ObjectPluginMetrics = s3ObjectPluginMetrics;
    }

    public S3ObjectReference getObjectReference() {
        return this.s3ObjectReference;
    }

    public long getLength() {
        return this.getMetadata().contentLength();
    }

    public Instant getLastModified() {
        return this.getMetadata().lastModified();
    }

    public SeekableInputStream newStream() {
        return new S3InputStream(this.s3Client, this.s3ObjectReference, this.bucketOwnerProvider, this.getMetadata(), this.s3ObjectPluginMetrics, DEFAULT_RETRY_DELAY, 10);
    }

    private synchronized HeadObjectResponse getMetadata() {
        if (this.metadata == null) {
            HeadObjectRequest.Builder headRequestBuilder = HeadObjectRequest.builder().bucket(this.s3ObjectReference.getBucketName()).key(this.s3ObjectReference.getKey());
            this.bucketOwnerProvider.getBucketOwner(this.s3ObjectReference.getBucketName()).ifPresent(arg_0 -> ((HeadObjectRequest.Builder)headRequestBuilder).expectedBucketOwner(arg_0));
            HeadObjectRequest request = (HeadObjectRequest)headRequestBuilder.build();
            this.metadata = this.s3Client.headObject(request);
        }
        return this.metadata;
    }
}

