/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.resync;

import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.ResyncPartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.StreamPartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.state.ResyncProgressState;
import org.opensearch.dataprepper.plugins.source.rds.model.ForeignKeyAction;
import org.opensearch.dataprepper.plugins.source.rds.model.ForeignKeyRelation;
import org.opensearch.dataprepper.plugins.source.rds.model.ParentTable;
import org.opensearch.dataprepper.plugins.source.rds.model.TableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadingActionDetector {
    private static final Logger LOG = LoggerFactory.getLogger(CascadingActionDetector.class);
    private final EnhancedSourceCoordinator sourceCoordinator;

    public CascadingActionDetector(EnhancedSourceCoordinator sourceCoordinator) {
        this.sourceCoordinator = sourceCoordinator;
    }

    public Map<String, ParentTable> getParentTableMap(StreamPartition streamPartition) {
        HashMap<String, ParentTable> parentTableMap = new HashMap<String, ParentTable>();
        if (streamPartition.getProgressState().isEmpty()) {
            return parentTableMap;
        }
        List<ForeignKeyRelation> foreignKeyRelations = streamPartition.getProgressState().get().getMySqlStreamState().getForeignKeyRelations();
        for (ForeignKeyRelation foreignKeyRelation : foreignKeyRelations) {
            ParentTable parentTable;
            if (!ForeignKeyRelation.containsCascadingAction(foreignKeyRelation)) continue;
            String fullParentTableName = this.getFullTableName(foreignKeyRelation.getDatabaseName(), foreignKeyRelation.getParentTableName());
            if (!parentTableMap.containsKey(fullParentTableName)) {
                HashMap<String, List<ForeignKeyRelation>> referencedColumnMap = new HashMap<String, List<ForeignKeyRelation>>();
                referencedColumnMap.put(foreignKeyRelation.getReferencedKeyName(), new ArrayList<ForeignKeyRelation>(List.of(foreignKeyRelation)));
                parentTable = ParentTable.builder().databaseName(foreignKeyRelation.getDatabaseName()).tableName(foreignKeyRelation.getParentTableName()).referencedColumnMap(referencedColumnMap).build();
                parentTableMap.put(fullParentTableName, parentTable);
                continue;
            }
            parentTable = (ParentTable)parentTableMap.get(fullParentTableName);
            if (!parentTable.getReferencedColumnMap().containsKey(foreignKeyRelation.getReferencedKeyName())) {
                parentTable.getReferencedColumnMap().put(foreignKeyRelation.getReferencedKeyName(), new ArrayList());
            }
            parentTable.getReferencedColumnMap().get(foreignKeyRelation.getReferencedKeyName()).add(foreignKeyRelation);
        }
        LOG.debug("ParentTables are {}", parentTableMap.keySet());
        return parentTableMap;
    }

    public void detectCascadingUpdates(Event event, Map<String, ParentTable> parentTableMap, TableMetadata tableMetadata) {
        UpdateRowsEventData data = (UpdateRowsEventData)event.getData();
        if (parentTableMap.containsKey(tableMetadata.getFullTableName())) {
            ParentTable parentTable = parentTableMap.get(tableMetadata.getFullTableName());
            for (Map.Entry row : data.getRows()) {
                LOG.debug("Checking for updated columns");
                Map<String, Object> updatedColumnsAndValues = IntStream.range(0, ((Serializable[])row.getKey()).length).filter(i -> !((Serializable[])row.getKey())[i].equals(((Serializable[])row.getValue())[i])).mapToObj(i -> tableMetadata.getColumnNames().get(i)).collect(Collectors.toMap(column -> column, column -> ((Serializable[])row.getValue())[tableMetadata.getColumnNames().indexOf(column)]));
                LOG.debug("These columns were updated: {}", updatedColumnsAndValues);
                LOG.debug("Decide whether to create resync partitions");
                for (String column2 : updatedColumnsAndValues.keySet()) {
                    if (!parentTable.getColumnsWithCascadingUpdate().containsKey(column2)) continue;
                    for (ForeignKeyRelation foreignKeyRelation : parentTable.getColumnsWithCascadingUpdate().get(column2)) {
                        if (foreignKeyRelation.getUpdateAction() == ForeignKeyAction.CASCADE) {
                            this.createResyncPartition(foreignKeyRelation.getDatabaseName(), foreignKeyRelation.getChildTableName(), foreignKeyRelation.getForeignKeyName(), updatedColumnsAndValues.get(column2), tableMetadata.getPrimaryKeys(), event.getHeader().getTimestamp());
                            continue;
                        }
                        if (foreignKeyRelation.getUpdateAction() == ForeignKeyAction.SET_NULL) {
                            this.createResyncPartition(foreignKeyRelation.getDatabaseName(), foreignKeyRelation.getChildTableName(), foreignKeyRelation.getForeignKeyName(), null, tableMetadata.getPrimaryKeys(), event.getHeader().getTimestamp());
                            continue;
                        }
                        if (foreignKeyRelation.getUpdateAction() != ForeignKeyAction.SET_DEFAULT) continue;
                        this.createResyncPartition(foreignKeyRelation.getDatabaseName(), foreignKeyRelation.getChildTableName(), foreignKeyRelation.getForeignKeyName(), foreignKeyRelation.getForeignKeyDefaultValue(), tableMetadata.getPrimaryKeys(), event.getHeader().getTimestamp());
                    }
                }
            }
        }
    }

    public void detectCascadingDeletes(Event event, Map<String, ParentTable> parentTableMap, TableMetadata tableMetadata) {
        if (parentTableMap.containsKey(tableMetadata.getFullTableName())) {
            ParentTable parentTable = parentTableMap.get(tableMetadata.getFullTableName());
            for (String column : parentTable.getColumnsWithCascadingDelete().keySet()) {
                for (ForeignKeyRelation foreignKeyRelation : parentTable.getColumnsWithCascadingDelete().get(column)) {
                    if (foreignKeyRelation.getDeleteAction() == ForeignKeyAction.CASCADE) {
                        LOG.warn("Cascade delete is not supported yet");
                        continue;
                    }
                    if (foreignKeyRelation.getDeleteAction() == ForeignKeyAction.SET_NULL) {
                        this.createResyncPartition(foreignKeyRelation.getDatabaseName(), foreignKeyRelation.getChildTableName(), foreignKeyRelation.getForeignKeyName(), null, tableMetadata.getPrimaryKeys(), event.getHeader().getTimestamp());
                        continue;
                    }
                    if (foreignKeyRelation.getDeleteAction() != ForeignKeyAction.SET_DEFAULT) continue;
                    this.createResyncPartition(foreignKeyRelation.getDatabaseName(), foreignKeyRelation.getChildTableName(), foreignKeyRelation.getForeignKeyName(), foreignKeyRelation.getForeignKeyDefaultValue(), tableMetadata.getPrimaryKeys(), event.getHeader().getTimestamp());
                }
            }
        }
    }

    private String getFullTableName(String database, String table) {
        return database + "." + table;
    }

    private void createResyncPartition(String database, String childTable, String foreignKeyName, Object updatedValue, List<String> primaryKeys, long eventTimestampMillis) {
        LOG.debug("Create Resyc partition for table {} and column {} with new value {}", new Object[]{childTable, foreignKeyName, updatedValue});
        ResyncProgressState progressState = new ResyncProgressState();
        progressState.setForeignKeyName(foreignKeyName);
        progressState.setUpdatedValue(updatedValue);
        progressState.setPrimaryKeys(primaryKeys);
        ResyncPartition resyncPartition = new ResyncPartition(database, childTable, eventTimestampMillis, progressState);
        this.sourceCoordinator.createPartition((EnhancedSourcePartition)resyncPartition);
    }
}

