/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.model;

import java.util.Set;

public enum ForeignKeyAction {
    CASCADE,
    NO_ACTION,
    RESTRICT,
    SET_DEFAULT,
    SET_NULL,
    UNKNOWN;

    private static final Set<ForeignKeyAction> CASCADING_ACTIONS;

    public static ForeignKeyAction getActionFromMetadata(short action) {
        switch (action) {
            case 0: {
                return CASCADE;
            }
            case 2: {
                return SET_NULL;
            }
            case 4: {
                return SET_DEFAULT;
            }
            case 1: {
                return RESTRICT;
            }
            case 3: {
                return NO_ACTION;
            }
        }
        return UNKNOWN;
    }

    public static boolean isCascadingAction(ForeignKeyAction foreignKeyAction) {
        if (foreignKeyAction == null) {
            return false;
        }
        return CASCADING_ACTIONS.contains((Object)foreignKeyAction);
    }

    static {
        CASCADING_ACTIONS = Set.of(CASCADE, SET_DEFAULT, SET_NULL);
    }
}

