/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.handler;

import org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.PostgresDataType;
import org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.PostgresDataTypeHandler;
import org.opensearch.dataprepper.plugins.source.rds.utils.PgArrayParser;

public class StringTypeHandler
implements PostgresDataTypeHandler {
    @Override
    public Object handle(PostgresDataType columnType, String columnName, Object value) {
        if (!columnType.isString()) {
            throw new IllegalArgumentException("ColumnType is not string: " + String.valueOf((Object)columnType));
        }
        if (columnType.isSubCategoryArray()) {
            return PgArrayParser.parseTypedArray(value.toString(), PostgresDataType.getScalarType(columnType), this::parseStringValue);
        }
        return this.parseStringValue(columnType, value.toString());
    }

    private Object parseStringValue(PostgresDataType columnType, String textValue) {
        return textValue;
    }
}

