/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

public class LogRateLimiter {
    public static int MILLIS_PER_SECOND = 1000;
    public static int MAX_LOGS_PER_SECOND = 1000;
    private int tokens;
    private long lastMs;
    private long replenishInterval;

    public LogRateLimiter(int ratePerSecond, long currentMs) {
        if (ratePerSecond < 0 || ratePerSecond > MAX_LOGS_PER_SECOND) {
            throw new IllegalArgumentException(String.format("Invalid arguments. ratePerSecond should be >0 and less than %s", MAX_LOGS_PER_SECOND));
        }
        this.replenishInterval = MILLIS_PER_SECOND / ratePerSecond;
        this.lastMs = currentMs;
        this.tokens = 1;
    }

    public boolean isAllowed(long currentMs) {
        if (currentMs - this.lastMs >= this.replenishInterval) {
            this.tokens = 1;
            this.lastMs = currentMs;
        }
        if (this.tokens == 0) {
            return false;
        }
        --this.tokens;
        return true;
    }
}

