/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.crowdstrike;

import java.time.Instant;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.annotations.Experimental;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.source.crowdstrike.CrowdStrikeSourceConfig;
import org.opensearch.dataprepper.plugins.source.crowdstrike.rest.CrowdStrikeAuthClient;
import org.opensearch.dataprepper.plugins.source.source_crawler.CrawlerApplicationContextMarker;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.Crawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourceConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourcePlugin;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.LeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.PluginExecutorServiceProvider;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.TimeSliceCrawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.CrowdStrikeLeaderProgressState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@DataPrepperPlugin(name="crowdstrike", pluginType=Source.class, pluginConfigurationType=CrowdStrikeSourceConfig.class, packagesToScan={CrawlerApplicationContextMarker.class, CrowdStrikeSource.class})
public class CrowdStrikeSource
extends CrawlerSourcePlugin {
    private static final Logger log = LoggerFactory.getLogger(CrowdStrikeSource.class);
    private final CrowdStrikeSourceConfig sourceConfig;
    private final CrowdStrikeAuthClient authClient;

    @DataPrepperPluginConstructor
    public CrowdStrikeSource(CrowdStrikeSourceConfig sourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, AcknowledgementSetManager acknowledgementSetManager, CrowdStrikeAuthClient authClient, TimeSliceCrawler crawler, PluginExecutorServiceProvider executorServiceProvider) {
        super("crowdstrike", pluginMetrics, (CrawlerSourceConfig)sourceConfig, pluginFactory, acknowledgementSetManager, (Crawler)crawler, executorServiceProvider);
        log.info("Creating CrowdStrike Source Plugin");
        this.sourceConfig = sourceConfig;
        this.authClient = authClient;
    }

    public void start(Buffer<Record<Event>> buffer) {
        log.info("Starting CrowdStrike Source Plugin...");
        this.authClient.initCredentials();
        super.start(buffer);
    }

    protected LeaderProgressState createLeaderProgressState() {
        return new CrowdStrikeLeaderProgressState(Instant.now(), this.sourceConfig.getLookBackDays());
    }

    public void stop() {
        log.info("Stopping CrowdStrike Source Plugin...");
        super.stop();
    }
}

