/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.confluence.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class NameConfig {
    public static final Pattern VALID_SPACE_KEY_REGEX = Pattern.compile("^[A-Za-z0-9]+$");
    @JsonProperty(value="include")
    @Size(max=100, message="Space name type filter should not be more than 100")
    @Size(max=100, message="Space name type filter should not be more than 100") List<String> include = new ArrayList<String>();
    @JsonProperty(value="exclude")
    @Size(max=100, message="Space name type filter should not be more than 100")
    @Size(max=100, message="Space name type filter should not be more than 100") List<String> exclude = new ArrayList<String>();

    @AssertTrue(message="Confluence Space keys should be alphanumeric")
    @AssertTrue(message="Confluence Space keys should be alphanumeric") boolean isValidSpaceKeys() {
        return this.checkGivenListForRegex(this.include) && this.checkGivenListForRegex(this.exclude);
    }

    boolean checkGivenListForRegex(List<String> list) {
        for (String value : list) {
            if (value != null && VALID_SPACE_KEY_REGEX.matcher(value).matches()) continue;
            return false;
        }
        return true;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public List<String> getExclude() {
        return this.exclude;
    }
}

