/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.file;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum FileFormat {
    PLAIN("plain"),
    JSON("json");

    private static final Map<String, FileFormat> NAMES_MAP;
    private final String name;

    private FileFormat(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static FileFormat getByName(String name) {
        return NAMES_MAP.get(name.toLowerCase());
    }

    static {
        NAMES_MAP = Arrays.stream(FileFormat.values()).collect(Collectors.toMap(FileFormat::toString, Function.identity()));
    }
}

