/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.util;

import java.util.Set;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.ServiceException;
import software.amazon.awssdk.services.lambda.model.TooManyRequestsException;

public final class LambdaRetryStrategy {
    private static final Set<Integer> BAD_REQUEST_ERRORS = Set.of(Integer.valueOf(400), Integer.valueOf(422), Integer.valueOf(417), Integer.valueOf(406));
    private static final Set<Integer> NOT_ALLOWED_ERRORS = Set.of(Integer.valueOf(401), Integer.valueOf(403), Integer.valueOf(405));
    private static final Set<Integer> INVALID_INPUT_ERRORS = Set.of(Integer.valueOf(413), Integer.valueOf(414), Integer.valueOf(416));
    private static final Set<Integer> TIMEOUT_ERRORS = Set.of(Integer.valueOf(408), Integer.valueOf(429));

    private LambdaRetryStrategy() {
    }

    public static boolean isRetryableStatusCode(int statusCode) {
        return TIMEOUT_ERRORS.contains(statusCode) || statusCode >= 500 && statusCode < 600;
    }

    public static boolean isRetryableException(Throwable t) {
        if (t instanceof TooManyRequestsException) {
            return true;
        }
        if (t instanceof ServiceException) {
            return true;
        }
        return t instanceof SdkClientException;
    }

    public static boolean isNonRetryable(InvokeResponse response) {
        if (response == null) {
            return false;
        }
        int statusCode = response.statusCode();
        return BAD_REQUEST_ERRORS.contains(statusCode) || NOT_ALLOWED_ERRORS.contains(statusCode) || INVALID_INPUT_ERRORS.contains(statusCode);
    }

    public static boolean isTimeoutError(InvokeResponse response) {
        return TIMEOUT_ERRORS.contains(response.statusCode());
    }
}

