/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.avro;

import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.opensearch.dataprepper.avro.SchemaGenerationException;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;

public class AvroAutoSchemaGenerator {
    public Schema autoDetermineSchema(Map<String, Object> data, OutputCodecContext outputCodecContext) {
        return this.autoGenerateRecordSchema(data, outputCodecContext, "Event");
    }

    private Schema autoGenerateRecordSchema(Map<String, Object> eventData, OutputCodecContext codecContext, String typeName) {
        SchemaBuilder.FieldAssembler fieldsAssembler = SchemaBuilder.record((String)typeName).fields();
        for (String key : eventData.keySet()) {
            if (codecContext != null && codecContext.shouldNotIncludeKey(key)) continue;
            Schema schemaForValue = this.createSchemaForValue(key, eventData.get(key), codecContext);
            fieldsAssembler = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)fieldsAssembler.name(key).type().unionOf().nullType().and().type(schemaForValue)).endUnion()).nullDefault();
        }
        return (Schema)fieldsAssembler.endRecord();
    }

    private Schema createSchemaForValue(String key, Object value, OutputCodecContext codecContext) {
        if (value == null) {
            throw new SchemaGenerationException("Unable to auto-generate a schema because a provided value is null. key='" + key + "'.");
        }
        if (value instanceof String) {
            return (Schema)SchemaBuilder.builder().stringType();
        }
        if (value instanceof Long) {
            return (Schema)SchemaBuilder.builder().longType();
        }
        if (value instanceof Integer) {
            return (Schema)SchemaBuilder.builder().intType();
        }
        if (value instanceof Float) {
            return (Schema)SchemaBuilder.builder().floatType();
        }
        if (value instanceof Double) {
            return (Schema)SchemaBuilder.builder().doubleType();
        }
        if (value instanceof Boolean) {
            return (Schema)SchemaBuilder.builder().booleanType();
        }
        if (value instanceof Byte[] || value instanceof byte[]) {
            return (Schema)SchemaBuilder.builder().bytesType();
        }
        if (value instanceof Map) {
            return this.autoGenerateRecordSchema((Map)value, codecContext, this.convertFieldNameToTypeName(key));
        }
        if (value instanceof List) {
            List listProvided = (List)value;
            if (listProvided.isEmpty()) {
                throw new SchemaGenerationException("Cannot determine the element type for the Avro array because a provided list is empty and has no type information. key='" + key + "'.");
            }
            Object sampleElement = listProvided.get(0);
            return (Schema)SchemaBuilder.builder().array().items(this.nullableType(this.createSchemaForValue(null, sampleElement, codecContext)));
        }
        throw new SchemaGenerationException("Unable to auto-generate a schema for field '" + key + "' because the the type '" + String.valueOf(value.getClass()) + "' is not a recognized type for auto-generation.");
    }

    private Schema nullableType(Schema schema) {
        return (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()).and().type(schema)).endUnion();
    }

    private String convertFieldNameToTypeName(String fieldName) {
        char startCharacter = fieldName.charAt(0);
        if (Character.isAlphabetic(startCharacter)) {
            startCharacter = Character.toUpperCase(startCharacter);
        }
        char[] typeChars = new char[fieldName.length()];
        typeChars[0] = startCharacter;
        fieldName.getChars(1, fieldName.length(), typeChars, 1);
        return new String(typeChars);
    }
}

