/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.opensearch.dataprepper.avro.AvroAutoSchemaGenerator;
import org.opensearch.dataprepper.avro.AvroEventConverter;
import org.opensearch.dataprepper.avro.EventDefinedAvroEventConverter;
import org.opensearch.dataprepper.avro.SchemaDefinedAvroEventConverter;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.codec.avro.AvroOutputCodecConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="avro", pluginType=OutputCodec.class, pluginConfigurationType=AvroOutputCodecConfig.class)
public class AvroOutputCodec
implements OutputCodec {
    private static final Logger LOG = LoggerFactory.getLogger(AvroOutputCodec.class);
    private static final String AVRO = "avro";
    private final AvroOutputCodecConfig config;
    private final AvroEventConverter avroEventConverter;
    private final AvroAutoSchemaGenerator avroAutoSchemaGenerator;
    private DataFileWriter<GenericRecord> dataFileWriter;
    private Schema schema;
    private OutputCodecContext codecContext;

    @DataPrepperPluginConstructor
    public AvroOutputCodec(AvroOutputCodecConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
        this.avroAutoSchemaGenerator = new AvroAutoSchemaGenerator();
        if (config.getSchema() != null) {
            this.schema = this.parseSchema(config.getSchema());
            this.avroEventConverter = new SchemaDefinedAvroEventConverter();
        } else {
            this.avroEventConverter = new EventDefinedAvroEventConverter();
        }
    }

    public void start(OutputStream outputStream, Event event, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(codecContext);
        this.codecContext = codecContext;
        if (this.schema == null) {
            this.schema = this.buildInlineSchemaFromEvent(event);
        }
        GenericDatumWriter datumWriter = new GenericDatumWriter(this.schema);
        this.dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        this.dataFileWriter.create(this.schema, outputStream);
    }

    public Schema buildInlineSchemaFromEvent(Event event) throws IOException {
        Map data = this.codecContext != null && this.codecContext.getTagsTargetKey() != null ? this.addTagsToEvent(event, this.codecContext.getTagsTargetKey()).toMap() : event.toMap();
        return this.avroAutoSchemaGenerator.autoDetermineSchema(data, this.codecContext);
    }

    public void complete(OutputStream outputStream) throws IOException {
        this.dataFileWriter.close();
        outputStream.close();
    }

    public void writeEvent(Event event, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(event);
        Map data = this.codecContext.getTagsTargetKey() != null ? this.addTagsToEvent(event, this.codecContext.getTagsTargetKey()).toMap() : event.toMap();
        GenericRecord avroRecord = this.avroEventConverter.convertEventDataToAvro(this.schema, data, this.codecContext);
        this.dataFileWriter.append((Object)avroRecord);
    }

    public String getExtension() {
        return AVRO;
    }

    public void validateAgainstCodecContext(OutputCodecContext outputCodecContext) {
        if (this.config.isAutoSchema()) {
            return;
        }
        if (outputCodecContext.getIncludeKeys() != null && !outputCodecContext.getIncludeKeys().isEmpty() || outputCodecContext.getExcludeKeys() != null && !outputCodecContext.getExcludeKeys().isEmpty()) {
            throw new InvalidPluginConfigurationException("Providing a user-defined schema and using sink include or exclude keys is not an allowed configuration.");
        }
    }

    Schema parseSchema(String schemaString) {
        try {
            Objects.requireNonNull(schemaString);
            return new Schema.Parser().parse(schemaString);
        }
        catch (Exception e) {
            LOG.error("Unable to parse Schema from Schema String provided.", (Throwable)e);
            throw new RuntimeException("There is an error in the schema: " + e.getMessage());
        }
    }
}

