/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.schemas;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaVersion;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugin.ClasspathPluginProvider;
import org.opensearch.dataprepper.plugin.PluginProvider;
import org.opensearch.dataprepper.schemas.JsonSchemaConverter;
import org.opensearch.dataprepper.schemas.PluginConfigsJsonSchemaConverter;
import org.opensearch.dataprepper.schemas.PrimaryFieldsOverride;
import org.opensearch.dataprepper.schemas.module.DataPrepperModules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class DataPrepperPluginSchemaExecute
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DataPrepperPluginSchemaExecute.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    static final String DEFAULT_PLUGINS_CLASSPATH = "org.opensearch.dataprepper.plugins";
    @CommandLine.Option(names={"--plugin_type"}, required=true)
    private String pluginTypeName;
    @CommandLine.Option(names={"--plugin_names"})
    private String pluginNames;
    @CommandLine.Option(names={"--primary_fields_override"})
    private String primaryFieldsOverrideFilePath;
    @CommandLine.Option(names={"--site.url"}, defaultValue="https://opensearch.org")
    private String siteUrl;
    @CommandLine.Option(names={"--site.baseurl"}, defaultValue="/docs/latest")
    private String siteBaseUrl;
    @CommandLine.Option(names={"--output_folder"})
    private String folderPath;

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new DataPrepperPluginSchemaExecute()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public void run() {
        Map filteredPluginNameToJsonSchemaMap;
        PrimaryFieldsOverride primaryFieldsOverride;
        ClasspathPluginProvider pluginProvider = new ClasspathPluginProvider();
        try {
            primaryFieldsOverride = this.primaryFieldsOverrideFilePath == null ? new PrimaryFieldsOverride() : (PrimaryFieldsOverride)OBJECT_MAPPER.readValue(new File(this.primaryFieldsOverrideFilePath), PrimaryFieldsOverride.class);
        }
        catch (IOException e) {
            throw new RuntimeException("primary fields override filepath does not exist. ", e);
        }
        PluginConfigsJsonSchemaConverter pluginConfigsJsonSchemaConverter = new PluginConfigsJsonSchemaConverter((PluginProvider)pluginProvider, new JsonSchemaConverter(DataPrepperModules.dataPrepperModules(), (PluginProvider)pluginProvider), primaryFieldsOverride, this.siteUrl, this.siteBaseUrl);
        Class pluginType = pluginConfigsJsonSchemaConverter.pluginTypeNameToPluginType(this.pluginTypeName);
        Map pluginNameToJsonSchemaMap = pluginConfigsJsonSchemaConverter.convertPluginConfigsIntoJsonSchemas(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON, pluginType);
        if (this.pluginNames == null) {
            filteredPluginNameToJsonSchemaMap = pluginNameToJsonSchemaMap;
        } else {
            Set<String> pluginNamesSet = Set.of(this.pluginNames.split(","));
            filteredPluginNameToJsonSchemaMap = pluginNamesSet.stream().filter(name -> {
                if (!pluginNameToJsonSchemaMap.containsKey(name)) {
                    LOG.error("plugin name: {} not found", name);
                    return false;
                }
                return true;
            }).collect(Collectors.toMap(Function.identity(), pluginNameToJsonSchemaMap::get));
        }
        if (this.folderPath == null) {
            DataPrepperPluginSchemaExecute.writeCollectionToConsole(filteredPluginNameToJsonSchemaMap.values());
        } else {
            DataPrepperPluginSchemaExecute.writeMapToFiles(filteredPluginNameToJsonSchemaMap, this.folderPath);
        }
    }

    private static void writeCollectionToConsole(Collection<String> values) {
        values.forEach(System.out::println);
    }

    private static void writeMapToFiles(Map<String, String> map, String folderPath) {
        Path directory = Paths.get(folderPath, new String[0]);
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("Error creating directory: " + e.getMessage());
                return;
            }
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String fileName = entry.getKey() + ".json";
            Path filePath = directory.resolve(fileName);
            try {
                Files.write(filePath, entry.getValue().getBytes(), new OpenOption[0]);
                System.out.println("Written file: " + String.valueOf(filePath));
            }
            catch (IOException e) {
                System.err.println("Error writing file " + fileName + ": " + e.getMessage());
            }
        }
    }
}

