/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;

public class PluginSetting
implements PipelineDescription {
    private static final String UNEXPECTED_ATTRIBUTE_TYPE_MSG = "Unexpected type [%s] for attribute [%s]";
    private final String name;
    private Map<String, Object> settings;
    private int processWorkers;
    private String pipelineName;

    public PluginSetting(String name, Map<String, Object> settings) {
        this.name = name;
        this.settings = settings;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
    }

    @Override
    public int getNumberOfProcessWorkers() {
        return this.processWorkers;
    }

    public void setProcessWorkers(int processWorkers) {
        this.processWorkers = processWorkers;
    }

    @Override
    public String getPipelineName() {
        return this.pipelineName;
    }

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public Object getAttributeFromSettings(String attribute) {
        return this.settings == null ? null : this.settings.get(attribute);
    }

    public Object getAttributeOrDefault(String attribute, Object defaultValue) {
        return this.settings == null ? defaultValue : this.settings.getOrDefault(attribute, defaultValue);
    }

    public Integer getIntegerOrDefault(String attribute, Integer defaultValue) {
        Object object = this.getAttributeOrDefault(attribute, defaultValue);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.valueOf(String.valueOf(object));
        }
        throw new IllegalArgumentException(String.format(UNEXPECTED_ATTRIBUTE_TYPE_MSG, object.getClass(), attribute));
    }

    public String getStringOrDefault(String attribute, String defaultValue) {
        Object object = this.getAttributeOrDefault(attribute, defaultValue);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return String.valueOf(object);
        }
        throw new IllegalArgumentException(String.format(UNEXPECTED_ATTRIBUTE_TYPE_MSG, object.getClass(), attribute));
    }

    public <T> List<T> getTypedList(String attribute, Class<T> type) {
        Object object = this.getAttributeOrDefault(attribute, Collections.emptyList());
        if (object == null) {
            return null;
        }
        this.checkObjectForListType(attribute, object, type);
        return (List)object;
    }

    public <K, V> List<Map<K, V>> getTypedListOfMaps(String attribute, Class<K> keyType, Class<V> valueType) {
        Object object = this.getAttributeOrDefault(attribute, null);
        if (object == null) {
            return null;
        }
        this.checkObjectType(attribute, object, List.class);
        for (Map listItem : (List)object) {
            listItem.forEach((key, value) -> {
                this.checkObjectType(attribute, key, keyType);
                this.checkObjectType(attribute, value, valueType);
            });
        }
        return (List)object;
    }

    public <K, V> Map<K, V> getTypedMap(String attribute, Class<K> keyType, Class<V> valueType) {
        Object object = this.getAttributeOrDefault(attribute, Collections.emptyMap());
        if (object == null) {
            return null;
        }
        this.checkObjectType(attribute, object, Map.class);
        ((Map)object).forEach((key, value) -> {
            this.checkObjectType(attribute, key, keyType);
            this.checkObjectType(attribute, value, valueType);
        });
        return (Map)object;
    }

    public <K, V> Map<K, List<V>> getTypedListMap(String attribute, Class<K> keyType, Class<V> valueType) {
        Object object = this.getAttributeOrDefault(attribute, Collections.emptyMap());
        if (object == null) {
            return null;
        }
        this.checkObjectType(attribute, object, Map.class);
        ((Map)object).forEach((key, value) -> {
            this.checkObjectType(attribute, key, keyType);
            this.checkObjectForListType(attribute, value, valueType);
        });
        return (Map)object;
    }

    public Boolean getBooleanOrDefault(String attribute, Boolean defaultValue) {
        Object object = this.getAttributeOrDefault(attribute, defaultValue);
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf(String.valueOf(object));
        }
        throw new IllegalArgumentException(String.format(UNEXPECTED_ATTRIBUTE_TYPE_MSG, object.getClass(), attribute));
    }

    public Long getLongOrDefault(String attribute, long defaultValue) {
        Object object = this.getAttributeOrDefault(attribute, defaultValue);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.valueOf(String.valueOf(object));
        }
        throw new IllegalArgumentException(String.format(UNEXPECTED_ATTRIBUTE_TYPE_MSG, object.getClass(), attribute));
    }

    private <T> void checkObjectType(String attribute, Object object, Class<T> type) {
        if (object != null && !type.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException(String.format(UNEXPECTED_ATTRIBUTE_TYPE_MSG, object.getClass(), attribute));
        }
    }

    private <T> void checkObjectForListType(String attribute, Object object, Class<T> type) {
        this.checkObjectType(attribute, object, List.class);
        ((List)object).forEach(o -> this.checkObjectType(attribute, o, type));
    }
}

