/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.source.coordinator;

import java.util.Objects;
import org.opensearch.dataprepper.model.source.coordinator.PartitionIdentifier;

public class SourcePartition<T> {
    private final PartitionIdentifier partitionIdentifier;
    private final T partitionState;

    private SourcePartition(Builder<T> builder) {
        Objects.requireNonNull(builder.partitionIdentifier);
        this.partitionIdentifier = builder.partitionIdentifier;
        this.partitionState = builder.partitionState;
    }

    public PartitionIdentifier getPartition() {
        return this.partitionIdentifier;
    }

    public T getPartitionState() {
        return this.partitionState;
    }

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    public static class Builder<T> {
        private PartitionIdentifier partitionIdentifier;
        private T partitionState;

        public Builder(Class<T> clazz) {
        }

        public Builder<T> withPartition(PartitionIdentifier partitionIdentifier) {
            this.partitionIdentifier = partitionIdentifier;
            return this;
        }

        public Builder<T> withPartitionState(T partitionState) {
            this.partitionState = partitionState;
            return this;
        }

        public SourcePartition<T> build() {
            return new SourcePartition(this);
        }
    }
}

