/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.sink;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.sink.SinkThread;

public abstract class AbstractSink<T extends Record<?>>
implements Sink<T> {
    protected static final int NUMBER_OF_RETRIES = 600;
    protected final PluginMetrics pluginMetrics;
    private final Counter recordsInCounter;
    private final Timer timeElapsedTimer;
    private Thread retryThread;

    public AbstractSink(PluginSetting pluginSetting) {
        this.pluginMetrics = PluginMetrics.fromPluginSetting(pluginSetting);
        this.recordsInCounter = this.pluginMetrics.counter("recordsIn");
        this.timeElapsedTimer = this.pluginMetrics.timer("timeElapsed");
        this.retryThread = null;
    }

    public abstract void doInitialize();

    @Override
    public void initialize() {
        this.doInitialize();
        if (!this.isReady() && this.retryThread == null) {
            this.retryThread = new Thread(new SinkThread(this, 600));
            this.retryThread.start();
        }
    }

    @Override
    public void output(Collection<T> records) {
        this.recordsInCounter.increment((double)records.size() * 1.0);
        this.timeElapsedTimer.record(() -> this.doOutput(records));
    }

    public abstract void doOutput(Collection<T> var1);

    @Override
    public void shutdown() {
        if (this.retryThread != null) {
            this.retryThread.stop();
        }
    }

    Thread.State getRetryThreadState() {
        if (this.retryThread != null) {
            return this.retryThread.getState();
        }
        return null;
    }
}

