/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.sink;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.pipeline.HeadlessPipeline;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.SinkForwardRecordsContext;

public class SinkContext {
    private final String tagsTargetKey;
    private final Collection<String> routes;
    private final List<String> includeKeys;
    private final List<String> excludeKeys;
    private Map<String, HeadlessPipeline> forwardToPipelines;

    public SinkContext(String tagsTargetKey, Collection<String> routes, List<String> includeKeys, List<String> excludeKeys) {
        this.tagsTargetKey = tagsTargetKey;
        this.routes = routes;
        this.includeKeys = includeKeys;
        this.excludeKeys = excludeKeys;
        this.forwardToPipelines = new HashMap<String, HeadlessPipeline>();
    }

    public SinkContext(String tagsTargetKey, Collection<String> routes, List<String> includeKeys, List<String> excludeKeys, List<String> forwardPipelineNames) {
        this.tagsTargetKey = tagsTargetKey;
        this.routes = routes;
        this.includeKeys = includeKeys;
        this.excludeKeys = excludeKeys;
        this.forwardToPipelines = new HashMap<String, HeadlessPipeline>();
        if (forwardPipelineNames != null) {
            for (String forwardPipelineName : forwardPipelineNames) {
                this.forwardToPipelines.put(forwardPipelineName, null);
            }
        }
    }

    public SinkContext(String tagsTargetKey) {
        this(tagsTargetKey, null, null, null, null);
    }

    public void setForwardToPipelines(Map<String, HeadlessPipeline> pipelines) {
        for (Map.Entry<String, HeadlessPipeline> entry : this.forwardToPipelines.entrySet()) {
            String key = entry.getKey();
            HeadlessPipeline pipeline = pipelines.get(key);
            if (pipeline != null) {
                this.forwardToPipelines.put(key, pipeline);
                continue;
            }
            throw new RuntimeException(String.format("forwarding pipeline {} doesn't exist", key));
        }
    }

    public boolean forwardRecords(SinkForwardRecordsContext sinkForwardRecordsContext, Map<String, Object> withData, Map<String, Object> withMetadata) {
        if (this.forwardToPipelines.size() == 0) {
            return false;
        }
        for (Map.Entry<String, HeadlessPipeline> entry : this.forwardToPipelines.entrySet()) {
            if (entry.getValue() != null) continue;
            return false;
        }
        List<Record<Event>> records = sinkForwardRecordsContext.getRecords();
        if (records.size() == 0) {
            return true;
        }
        records.forEach(record -> {
            Event event = (Event)record.getData();
            if (withData != null && !withData.isEmpty()) {
                for (Map.Entry entry : withData.entrySet()) {
                    event.put((String)entry.getKey(), entry.getValue());
                }
            }
            if (withMetadata != null && !withMetadata.isEmpty()) {
                EventMetadata metadata = event.getMetadata();
                for (Map.Entry entry : withMetadata.entrySet()) {
                    metadata.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
        });
        for (Map.Entry<String, HeadlessPipeline> entry : this.forwardToPipelines.entrySet()) {
            entry.getValue().sendEvents(records);
        }
        return true;
    }

    public String getTagsTargetKey() {
        return this.tagsTargetKey;
    }

    public Collection<String> getRoutes() {
        return this.routes;
    }

    public List<String> getIncludeKeys() {
        return this.includeKeys;
    }

    public List<String> getExcludeKeys() {
        return this.excludeKeys;
    }

    public Map<String, HeadlessPipeline> getForwardToPipelines() {
        return this.forwardToPipelines;
    }
}

