/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.time.Instant;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.event.AbstractEventHandle;
import org.opensearch.dataprepper.model.event.EventHandle;

public class DefaultEventHandle
extends AbstractEventHandle
implements Serializable {
    private WeakReference<AcknowledgementSet> acknowledgementSetRef = null;

    public DefaultEventHandle(Instant internalOriginationTime) {
        super(internalOriginationTime);
    }

    @Override
    public void addAcknowledgementSet(AcknowledgementSet acknowledgementSet) {
        this.acknowledgementSetRef = new WeakReference<AcknowledgementSet>(acknowledgementSet);
    }

    public AcknowledgementSet getAcknowledgementSet() {
        if (this.acknowledgementSetRef == null) {
            return null;
        }
        return (AcknowledgementSet)this.acknowledgementSetRef.get();
    }

    @Override
    public boolean hasAcknowledgementSet() {
        AcknowledgementSet acknowledgementSet = this.getAcknowledgementSet();
        return acknowledgementSet != null;
    }

    @Override
    public void addEventHandle(EventHandle eventHandle) {
        AcknowledgementSet acknowledgementSet = this.getAcknowledgementSet();
        if (acknowledgementSet != null) {
            acknowledgementSet.add(eventHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireReference() {
        DefaultEventHandle defaultEventHandle = this;
        synchronized (defaultEventHandle) {
            AcknowledgementSet acknowledgementSet = this.getAcknowledgementSet();
            if (acknowledgementSet != null) {
                acknowledgementSet.acquire(this);
            }
        }
    }

    @Override
    public boolean release(boolean result) {
        this.notifyReleaseConsumers(result);
        AcknowledgementSet acknowledgementSet = this.getAcknowledgementSet();
        if (acknowledgementSet != null) {
            acknowledgementSet.release(this, result);
            return true;
        }
        return false;
    }
}

