/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.configuration;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataPrepperVersion {
    private static final String CURRENT_VERSION = "2.10";
    private static final String FULL_FORMAT = "%d.%d";
    private static final String SHORTHAND_FORMAT = "%d";
    private static final String VERSION_PATTERN_STRING = "^((\\d+)(\\.(\\d+))?)$";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^((\\d+)(\\.(\\d+))?)$");
    private static final int MAJOR_VERSION_PATTERN_POSITION = 2;
    private static final int MINOR_VERSION_PATTERN_POSITION = 4;
    private final int majorVersion;
    private final Integer minorVersion;
    private static DataPrepperVersion instance;

    private DataPrepperVersion(int majorVersion, Integer minorVersion) {
        this.minorVersion = minorVersion;
        this.majorVersion = majorVersion;
    }

    public static DataPrepperVersion getCurrentVersion() {
        if (Objects.isNull(instance)) {
            instance = DataPrepperVersion.parse(CURRENT_VERSION);
        }
        return instance;
    }

    public static DataPrepperVersion parse(String version) {
        Matcher result = VERSION_PATTERN.matcher(version);
        if (result.find()) {
            String major = result.group(2);
            int foundMajorVersion = Integer.parseInt(major);
            String potentialMinorVersion = result.group(4);
            Integer foundMinorVersion = potentialMinorVersion == null ? null : Integer.valueOf(Integer.parseInt(potentialMinorVersion));
            return new DataPrepperVersion(foundMajorVersion, foundMinorVersion);
        }
        throw new IllegalArgumentException("Invalid Data Prepper Version provided: " + version);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public Optional<Integer> getMinorVersion() {
        return Optional.ofNullable(this.minorVersion);
    }

    public boolean compatibleWith(DataPrepperVersion o) {
        if (this.majorVersion < o.getMajorVersion()) {
            return false;
        }
        if (this.majorVersion == o.majorVersion && this.minorVersion != null && o.getMinorVersion().isPresent() && !this.minorVersion.equals(o.getMinorVersion().get())) {
            return this.minorVersion > o.getMinorVersion().get();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof DataPrepperVersion) {
            DataPrepperVersion other = (DataPrepperVersion)o;
            return this.majorVersion == other.majorVersion && Objects.equals(this.minorVersion, other.getMinorVersion().orElse(null));
        }
        return false;
    }

    public String toString() {
        if (this.minorVersion == null) {
            return String.format(SHORTHAND_FORMAT, this.majorVersion);
        }
        return String.format(FULL_FORMAT, this.majorVersion, this.minorVersion);
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion);
    }
}

