/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.processor;

import com.amazon.dataprepper.metrics.PluginMetrics;
import com.amazon.dataprepper.model.configuration.PluginSetting;
import com.amazon.dataprepper.model.prepper.Prepper;
import com.amazon.dataprepper.model.record.Record;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;

public abstract class AbstractProcessor<InputRecord extends Record<?>, OutputRecord extends Record<?>>
implements Prepper<InputRecord, OutputRecord> {
    protected final PluginMetrics pluginMetrics;
    private final Counter recordsInCounter;
    private final Counter recordsOutCounter;
    private final Timer timeElapsedTimer;

    public AbstractProcessor(PluginSetting pluginSetting) {
        this.pluginMetrics = PluginMetrics.fromPluginSetting(pluginSetting);
        this.recordsInCounter = this.pluginMetrics.counter("recordsIn");
        this.recordsOutCounter = this.pluginMetrics.counter("recordsOut");
        this.timeElapsedTimer = this.pluginMetrics.timer("timeElapsed");
    }

    protected AbstractProcessor(PluginMetrics pluginMetrics) {
        this.pluginMetrics = pluginMetrics;
        this.recordsInCounter = pluginMetrics.counter("recordsIn");
        this.recordsOutCounter = pluginMetrics.counter("recordsOut");
        this.timeElapsedTimer = pluginMetrics.timer("timeElapsed");
    }

    @Override
    public Collection<OutputRecord> execute(Collection<InputRecord> records) {
        this.recordsInCounter.increment((double)records.size());
        Collection result = (Collection)this.timeElapsedTimer.record(() -> this.doExecute(records));
        this.recordsOutCounter.increment((double)result.size());
        return result;
    }

    public abstract Collection<OutputRecord> doExecute(Collection<InputRecord> var1);
}

