/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.data.client.osc.AutoCloseableOpenSearchClient;
import org.opensearch.data.client.osc.OpenSearchClients;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OpenSearchClientFactoryBean
implements FactoryBean<OpenSearchClient>,
InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(OpenSearchClientFactoryBean.class);
    @Nullable
    private AutoCloseableOpenSearchClient client;
    private String hosts = "http://localhost:9200";
    static final String COMMA = ",";

    public void destroy() {
        try {
            LOGGER.info((Object)"Closing elasticSearch  client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.buildClient();
    }

    public OpenSearchClient getObject() {
        if (this.client == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.client;
    }

    public Class<?> getObjectType() {
        return OpenSearchClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    protected void buildClient() throws Exception {
        Assert.hasText((String)this.hosts, (String)"[Assertion Failed] At least one host must be set.");
        ClientConfiguration clientConfiguration = ClientConfiguration.builder().connectedTo(this.hosts).build();
        this.client = (AutoCloseableOpenSearchClient)OpenSearchClients.createImperative(clientConfiguration);
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getHosts() {
        return this.hosts;
    }
}

