/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.core;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.ResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.MappingBuilder;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractIndexTemplate
implements IndexOperations {
    protected final ElasticsearchConverter elasticsearchConverter;
    @Nullable
    protected final Class<?> boundClass;
    @Nullable
    private final IndexCoordinates boundIndex;

    public AbstractIndexTemplate(ElasticsearchConverter elasticsearchConverter, Class<?> boundClass) {
        Assert.notNull(boundClass, (String)"boundClass may not be null");
        this.elasticsearchConverter = elasticsearchConverter;
        this.boundClass = boundClass;
        this.boundIndex = null;
    }

    public AbstractIndexTemplate(ElasticsearchConverter elasticsearchConverter, IndexCoordinates boundIndex) {
        Assert.notNull((Object)boundIndex, (String)"boundIndex may not be null");
        this.elasticsearchConverter = elasticsearchConverter;
        this.boundClass = null;
        this.boundIndex = boundIndex;
    }

    protected Class<?> checkForBoundClass() {
        if (this.boundClass == null) {
            throw new InvalidDataAccessApiUsageException("IndexOperations are not bound");
        }
        return this.boundClass;
    }

    public boolean create() {
        Settings settings = this.boundClass != null ? this.createSettings(this.boundClass) : new Settings();
        return this.doCreate(this.getIndexCoordinates(), (Map<String, Object>)settings, null);
    }

    public Settings createSettings(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        ElasticsearchPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(clazz);
        String settingPath = persistentEntity.settingPath();
        return StringUtils.hasText((String)settingPath) ? Settings.parse((String)ResourceUtil.readFileFromClasspath((String)settingPath)) : persistentEntity.getDefaultSettings();
    }

    public boolean createWithMapping() {
        return this.doCreate(this.getIndexCoordinates(), (Map<String, Object>)this.createSettings(), this.createMapping());
    }

    public boolean create(Map<String, Object> settings) {
        Assert.notNull(settings, (String)"settings must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, null);
    }

    public boolean create(Map<String, Object> settings, Document mapping) {
        Assert.notNull(settings, (String)"settings must not be null");
        Assert.notNull((Object)mapping, (String)"mapping must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, mapping);
    }

    protected abstract boolean doCreate(IndexCoordinates var1, Map<String, Object> var2, @Nullable Document var3);

    public boolean delete() {
        return this.doDelete(this.getIndexCoordinates());
    }

    protected abstract boolean doDelete(IndexCoordinates var1);

    public boolean exists() {
        return this.doExists(this.getIndexCoordinates());
    }

    protected abstract boolean doExists(IndexCoordinates var1);

    public boolean putMapping(Document mapping) {
        return this.doPutMapping(this.getIndexCoordinates(), mapping);
    }

    protected abstract boolean doPutMapping(IndexCoordinates var1, Document var2);

    public Map<String, Object> getMapping() {
        return this.doGetMapping(this.getIndexCoordinates());
    }

    protected abstract Map<String, Object> doGetMapping(IndexCoordinates var1);

    public Settings getSettings() {
        return this.getSettings(false);
    }

    public Settings getSettings(boolean includeDefaults) {
        return this.doGetSettings(this.getIndexCoordinates(), includeDefaults);
    }

    protected abstract Settings doGetSettings(IndexCoordinates var1, boolean var2);

    public void refresh() {
        this.doRefresh(this.getIndexCoordinates());
    }

    protected abstract void doRefresh(IndexCoordinates var1);

    public Map<String, Set<AliasData>> getAliases(String ... aliasNames) {
        Assert.notEmpty((Object[])aliasNames, (String)"aliasNames must not be empty");
        return this.doGetAliases(aliasNames, null);
    }

    public Map<String, Set<AliasData>> getAliasesForIndex(String ... indexNames) {
        Assert.notEmpty((Object[])indexNames, (String)"indexNames must not be empty");
        return this.doGetAliases(null, indexNames);
    }

    protected abstract Map<String, Set<AliasData>> doGetAliases(@Nullable String[] var1, @Nullable String[] var2);

    public Document createMapping() {
        return this.createMapping(this.checkForBoundClass());
    }

    public Document createMapping(Class<?> clazz) {
        String mappings;
        String mappingPath;
        Mapping mappingAnnotation = (Mapping)AnnotatedElementUtils.findMergedAnnotation(clazz, Mapping.class);
        if (mappingAnnotation != null && StringUtils.hasText((String)(mappingPath = mappingAnnotation.mappingPath())) && StringUtils.hasText((String)(mappings = ResourceUtil.readFileFromClasspath((String)mappingPath)))) {
            return Document.parse((String)mappings);
        }
        try {
            String mapping = new MappingBuilder(this.elasticsearchConverter).buildPropertyMapping(clazz);
            return Document.parse((String)mapping);
        }
        catch (Exception e) {
            throw new UncategorizedElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), (Throwable)e);
        }
    }

    public Settings createSettings() {
        return this.createSettings(this.checkForBoundClass());
    }

    ElasticsearchPersistentEntity<?> getRequiredPersistentEntity(Class<?> clazz) {
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    public IndexCoordinates getIndexCoordinates() {
        return this.boundClass != null ? this.getIndexCoordinatesFor(this.boundClass) : Objects.requireNonNull(this.boundIndex);
    }

    public IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return this.getRequiredPersistentEntity(clazz).getIndexCoordinates();
    }
}

