/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.rest_client.RestClientOptions;
import org.opensearch.data.client.osc.OpenSearchClients;
import org.opensearch.data.client.osc.ReactiveOpenSearchClient;
import org.opensearch.data.client.osc.ReactiveOpenSearchTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.config.ElasticsearchConfigurationSupport;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.util.Assert;

public abstract class ReactiveOpenSearchConfiguration
extends ElasticsearchConfigurationSupport {
    @Bean(name={"elasticsearchClientConfiguration"})
    public abstract ClientConfiguration clientConfiguration();

    @Bean
    public RestClient elasticsearchRestClient(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"clientConfiguration must not be null");
        return OpenSearchClients.getRestClient(clientConfiguration);
    }

    @Bean
    public OpenSearchTransport opensearchTransport(RestClient restClient, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        return OpenSearchClients.getOpenSearchTransport(restClient, "reactive", this.transportOptions(), jsonpMapper);
    }

    @Bean
    public ReactiveOpenSearchClient reactiveOpenSearchClient(OpenSearchTransport transport) {
        Assert.notNull((Object)transport, (String)"transport must not be null");
        return OpenSearchClients.createReactive(transport);
    }

    @Bean(name={"reactiveElasticsearchOperations", "reactiveElasticsearchTemplate", "reactiveOpensearchOperations", "reactiveOpensearchTemplate"})
    public ReactiveElasticsearchOperations reactiveElasticsearchOperations(ElasticsearchConverter elasticsearchConverter, ReactiveOpenSearchClient reactiveElasticsearchClient) {
        ReactiveOpenSearchTemplate template = new ReactiveOpenSearchTemplate(reactiveElasticsearchClient, elasticsearchConverter);
        template.setRefreshPolicy(this.refreshPolicy());
        return template;
    }

    @Bean
    public JsonpMapper jsonpMapper() {
        return new JacksonJsonpMapper();
    }

    public TransportOptions transportOptions() {
        return new RestClientOptions(RequestOptions.DEFAULT).toBuilder().build();
    }
}

