/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.KnnQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.search.FieldCollapse;
import org.opensearch.client.opensearch.core.search.Suggester;
import org.opensearch.data.client.osc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.BaseQueryBuilder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class NativeQuery
extends BaseQuery {
    @Nullable
    private final Query query;
    @Nullable
    private org.springframework.data.elasticsearch.core.query.Query springDataQuery;
    @Nullable
    private Query filter;
    private final Map<String, Aggregation> aggregations = new LinkedHashMap<String, Aggregation>();
    @Nullable
    private Suggester suggester;
    @Nullable
    private FieldCollapse fieldCollapse;
    private List<SortOptions> sortOptions = Collections.emptyList();
    private Map<String, JsonData> searchExtensions = Collections.emptyMap();
    @Nullable
    private KnnQuery knnQuery;

    public NativeQuery(NativeQueryBuilder builder) {
        super((BaseQueryBuilder)builder);
        this.query = builder.getQuery();
        this.filter = builder.getFilter();
        this.aggregations.putAll(builder.getAggregations());
        this.suggester = builder.getSuggester();
        this.fieldCollapse = builder.getFieldCollapse();
        this.sortOptions = builder.getSortOptions();
        this.searchExtensions = builder.getSearchExtensions();
        if (builder.getSpringDataQuery() != null) {
            Assert.isTrue((!NativeQuery.class.isAssignableFrom(builder.getSpringDataQuery().getClass()) ? 1 : 0) != 0, (String)"Cannot add an NativeQuery in a NativeQuery");
        }
        this.springDataQuery = builder.getSpringDataQuery();
        this.knnQuery = builder.getKnnQuery();
    }

    public NativeQuery(@Nullable Query query) {
        this.query = query;
    }

    public static NativeQueryBuilder builder() {
        return new NativeQueryBuilder();
    }

    @Nullable
    public Query getQuery() {
        return this.query;
    }

    @Nullable
    public Query getFilter() {
        return this.filter;
    }

    public Map<String, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public Suggester getSuggester() {
        return this.suggester;
    }

    @Nullable
    public FieldCollapse getFieldCollapse() {
        return this.fieldCollapse;
    }

    public List<SortOptions> getSortOptions() {
        return this.sortOptions;
    }

    public Map<String, JsonData> getSearchExtensions() {
        return this.searchExtensions;
    }

    public void setSpringDataQuery(@Nullable org.springframework.data.elasticsearch.core.query.Query springDataQuery) {
        this.springDataQuery = springDataQuery;
    }

    @Nullable
    public KnnQuery getKnnQuery() {
        return this.knnQuery;
    }

    @Nullable
    public org.springframework.data.elasticsearch.core.query.Query getSpringDataQuery() {
        return this.springDataQuery;
    }
}

