/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import jakarta.json.JsonException;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpMapperBase;
import org.opensearch.client.json.JsonpSerializable;
import org.springframework.data.elasticsearch.core.document.Document;

final class JsonpUtils {
    static final JsonProvider DEFAULT_PROVIDER = JsonpUtils.provider();
    static final JsonpMapper DEFAULT_JSONP_MAPPER = new JsonpMapperBase(){

        public JsonProvider jsonProvider() {
            return DEFAULT_PROVIDER;
        }

        public <T> void serialize(T value, JsonGenerator generator) {
            if (value instanceof JsonpSerializable) {
                ((JsonpSerializable)value).serialize(generator, (JsonpMapper)this);
                return;
            }
            throw new JsonException("Cannot find a serializer for type " + value.getClass().getName() + ". Consider using a full-featured JsonpMapper");
        }

        protected <T> JsonpDeserializer<T> getDefaultDeserializer(Class<T> clazz) {
            throw new JsonException("Cannot find a default deserializer for type " + clazz.getName() + ". Consider using a full-featured JsonpMapper");
        }
    };

    private JsonpUtils() {
    }

    static JsonProvider provider() {
        return JsonProvider.provider();
    }

    static <T> T fromJson(Document document, JsonpDeserializer<T> deserializer) {
        try (JsonParser parser = DEFAULT_JSONP_MAPPER.jsonProvider().createParser((Reader)new StringReader(document.toJson()));){
            Object object = deserializer.deserialize(parser, DEFAULT_JSONP_MAPPER);
            return (T)object;
        }
    }
}

