/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class StopTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, StopTokenFilter> {
    @Nullable
    private final Boolean ignoreCase;
    @Nullable
    private final Boolean removeTrailing;
    @Nonnull
    private final List<String> stopwords;
    @Nullable
    private final String stopwordsPath;
    public static final JsonpDeserializer<StopTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StopTokenFilter::setupStopTokenFilterDeserializer);

    private StopTokenFilter(Builder builder) {
        super(builder);
        this.ignoreCase = builder.ignoreCase;
        this.removeTrailing = builder.removeTrailing;
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
        this.stopwordsPath = builder.stopwordsPath;
    }

    public static StopTokenFilter of(Function<Builder, ObjectBuilder<StopTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Stop;
    }

    @Nullable
    public final Boolean ignoreCase() {
        return this.ignoreCase;
    }

    @Nullable
    public final Boolean removeTrailing() {
        return this.removeTrailing;
    }

    @Nonnull
    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Nullable
    public final String stopwordsPath() {
        return this.stopwordsPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "stop");
        super.serializeInternal(generator, mapper);
        if (this.ignoreCase != null) {
            generator.writeKey("ignore_case");
            generator.write(this.ignoreCase.booleanValue());
        }
        if (this.removeTrailing != null) {
            generator.writeKey("remove_trailing");
            generator.write(this.removeTrailing.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.stopwordsPath != null) {
            generator.writeKey("stopwords_path");
            generator.write(this.stopwordsPath);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupStopTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        StopTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::ignoreCase, JsonpDeserializer.booleanDeserializer(), "ignore_case");
        op.add(Builder::removeTrailing, JsonpDeserializer.booleanDeserializer(), "remove_trailing");
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.add(Builder::stopwordsPath, JsonpDeserializer.stringDeserializer(), "stopwords_path");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreCase);
        result = 31 * result + Objects.hashCode(this.removeTrailing);
        result = 31 * result + Objects.hashCode(this.stopwords);
        result = 31 * result + Objects.hashCode(this.stopwordsPath);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StopTokenFilter other = (StopTokenFilter)o;
        return Objects.equals(this.ignoreCase, other.ignoreCase) && Objects.equals(this.removeTrailing, other.removeTrailing) && Objects.equals(this.stopwords, other.stopwords) && Objects.equals(this.stopwordsPath, other.stopwordsPath);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, StopTokenFilter> {
        @Nullable
        private Boolean ignoreCase;
        @Nullable
        private Boolean removeTrailing;
        @Nullable
        private List<String> stopwords;
        @Nullable
        private String stopwordsPath;

        public Builder() {
        }

        private Builder(StopTokenFilter o) {
            super(o);
            this.ignoreCase = o.ignoreCase;
            this.removeTrailing = o.removeTrailing;
            this.stopwords = Builder._listCopy(o.stopwords);
            this.stopwordsPath = o.stopwordsPath;
        }

        private Builder(Builder o) {
            super(o);
            this.ignoreCase = o.ignoreCase;
            this.removeTrailing = o.removeTrailing;
            this.stopwords = Builder._listCopy(o.stopwords);
            this.stopwordsPath = o.stopwordsPath;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder ignoreCase(@Nullable Boolean value) {
            this.ignoreCase = value;
            return this;
        }

        @Nonnull
        public final Builder removeTrailing(@Nullable Boolean value) {
            this.removeTrailing = value;
            return this;
        }

        @Nonnull
        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        @Nonnull
        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        @Nonnull
        public final Builder stopwordsPath(@Nullable String value) {
            this.stopwordsPath = value;
            return this;
        }

        @Override
        @Nonnull
        public StopTokenFilter build() {
            this._checkSingleUse();
            return new StopTokenFilter(this);
        }
    }
}

