/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.recovery;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class TranslogStatus
implements JsonpSerializable {
    private final String percent;
    private final long recovered;
    private final long total;
    private final long totalOnStart;
    @Nullable
    private final String totalTime;
    private final String totalTimeInMillis;
    public static final JsonpDeserializer<TranslogStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslogStatus::setupTranslogStatusDeserializer);

    private TranslogStatus(Builder builder) {
        this.percent = ApiTypeHelper.requireNonNull(builder.percent, this, "percent");
        this.recovered = ApiTypeHelper.requireNonNull(builder.recovered, this, "recovered");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.totalOnStart = ApiTypeHelper.requireNonNull(builder.totalOnStart, this, "totalOnStart");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
    }

    public static TranslogStatus of(Function<Builder, ObjectBuilder<TranslogStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String percent() {
        return this.percent;
    }

    public final long recovered() {
        return this.recovered;
    }

    public final long total() {
        return this.total;
    }

    public final long totalOnStart() {
        return this.totalOnStart;
    }

    @Nullable
    public final String totalTime() {
        return this.totalTime;
    }

    public final String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("percent");
        generator.write(this.percent);
        generator.writeKey("recovered");
        generator.write(this.recovered);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_on_start");
        generator.write(this.totalOnStart);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    protected static void setupTranslogStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::percent, JsonpDeserializer.stringDeserializer(), "percent");
        op.add(Builder::recovered, JsonpDeserializer.longDeserializer(), "recovered");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::totalOnStart, JsonpDeserializer.longDeserializer(), "total_on_start");
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TranslogStatus> {
        private String percent;
        private Long recovered;
        private Long total;
        private Long totalOnStart;
        @Nullable
        private String totalTime;
        private String totalTimeInMillis;

        public final Builder percent(String value) {
            this.percent = value;
            return this;
        }

        public final Builder recovered(long value) {
            this.recovered = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder totalOnStart(long value) {
            this.totalOnStart = value;
            return this;
        }

        public final Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        public TranslogStatus build() {
            this._checkSingleUse();
            return new TranslogStatus(this);
        }
    }
}

