/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.DistanceUnit;
import org.opensearch.client.opensearch._types.GeoDistanceType;
import org.opensearch.client.opensearch._types.GeoLocation;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationRange;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class GeoDistanceAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final GeoDistanceType distanceType;
    @Nullable
    private final String field;
    @Nullable
    private final GeoLocation origin;
    private final List<AggregationRange> ranges;
    @Nullable
    private final DistanceUnit unit;
    public static final JsonpDeserializer<GeoDistanceAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceAggregation::setupGeoDistanceAggregationDeserializer);

    private GeoDistanceAggregation(Builder builder) {
        super(builder);
        this.distanceType = builder.distanceType;
        this.field = builder.field;
        this.origin = builder.origin;
        this.ranges = ApiTypeHelper.unmodifiable(builder.ranges);
        this.unit = builder.unit;
    }

    public static GeoDistanceAggregation of(Function<Builder, ObjectBuilder<GeoDistanceAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeoDistance;
    }

    @Nullable
    public final GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final GeoLocation origin() {
        return this.origin;
    }

    public final List<AggregationRange> ranges() {
        return this.ranges;
    }

    @Nullable
    public final DistanceUnit unit() {
        return this.unit;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.origin != null) {
            generator.writeKey("origin");
            this.origin.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ranges)) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (AggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
    }

    protected static void setupGeoDistanceAggregationDeserializer(ObjectDeserializer<Builder> op) {
        GeoDistanceAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::origin, GeoLocation._DESERIALIZER, "origin");
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(AggregationRange._DESERIALIZER), "ranges");
        op.add(Builder::unit, DistanceUnit._DESERIALIZER, "unit");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoDistanceAggregation> {
        @Nullable
        private GeoDistanceType distanceType;
        @Nullable
        private String field;
        @Nullable
        private GeoLocation origin;
        @Nullable
        private List<AggregationRange> ranges;
        @Nullable
        private DistanceUnit unit;

        public final Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder origin(@Nullable GeoLocation value) {
            this.origin = value;
            return this;
        }

        public final Builder origin(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.origin(fn.apply(new GeoLocation.Builder()).build());
        }

        public final Builder ranges(List<AggregationRange> list) {
            this.ranges = Builder._listAddAll(this.ranges, list);
            return this;
        }

        public final Builder ranges(AggregationRange value, AggregationRange ... values) {
            this.ranges = Builder._listAdd(this.ranges, value, values);
            return this;
        }

        public final Builder ranges(Function<AggregationRange.Builder, ObjectBuilder<AggregationRange>> fn) {
            return this.ranges(fn.apply(new AggregationRange.Builder()).build(), new AggregationRange[0]);
        }

        public final Builder unit(@Nullable DistanceUnit value) {
            this.unit = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoDistanceAggregation build() {
            this._checkSingleUse();
            return new GeoDistanceAggregation(this);
        }
    }
}

