/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

//----------------------------------------------------
// THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------

package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

// typedef: ml.ToolItems

@JsonpDeserializable
@Generated("org.opensearch.client.codegen.CodeGenerator")
public class ToolItems implements PlainJsonSerializable, ToCopyableBuilder<ToolItems.Builder, ToolItems> {

    @Nullable
    private final Boolean includeOutputInAgentResponse;

    @Nonnull
    private final Map<String, JsonData> metadata;

    @Nullable
    private final String name;

    @Nonnull
    private final Map<String, JsonData> parameters;

    @Nullable
    private final String type;

    // ---------------------------------------------------------------------------------------------

    private ToolItems(Builder builder) {
        this.includeOutputInAgentResponse = builder.includeOutputInAgentResponse;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.name = builder.name;
        this.parameters = ApiTypeHelper.unmodifiable(builder.parameters);
        this.type = builder.type;
    }

    public static ToolItems of(Function<ToolItems.Builder, ObjectBuilder<ToolItems>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * API name: {@code include_output_in_agent_response}
     */
    @Nullable
    public final Boolean includeOutputInAgentResponse() {
        return this.includeOutputInAgentResponse;
    }

    @Nonnull
    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    /**
     * API name: {@code name}
     */
    @Nullable
    public final String name() {
        return this.name;
    }

    /**
     * API name: {@code parameters}
     */
    @Nonnull
    public final Map<String, JsonData> parameters() {
        return this.parameters;
    }

    /**
     * API name: {@code type}
     */
    @Nullable
    public final String type() {
        return this.type;
    }

    /**
     * Serialize this object to JSON.
     */
    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (this.includeOutputInAgentResponse != null) {
            generator.writeKey("include_output_in_agent_response");
            generator.write(this.includeOutputInAgentResponse);
        }

        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }

        if (ApiTypeHelper.isDefined(this.parameters)) {
            generator.writeKey("parameters");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.parameters.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }

        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    // ---------------------------------------------------------------------------------------------

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    /**
     * Builder for {@link ToolItems}.
     */
    public static class Builder extends ObjectBuilderBase implements CopyableBuilder<Builder, ToolItems> {
        @Nullable
        private Boolean includeOutputInAgentResponse;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String name;
        @Nullable
        private Map<String, JsonData> parameters;
        @Nullable
        private String type;

        public Builder() {}

        private Builder(ToolItems o) {
            this.includeOutputInAgentResponse = o.includeOutputInAgentResponse;
            this.metadata = _mapCopy(o.metadata);
            this.name = o.name;
            this.parameters = _mapCopy(o.parameters);
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.includeOutputInAgentResponse = o.includeOutputInAgentResponse;
            this.metadata = _mapCopy(o.metadata);
            this.name = o.name;
            this.parameters = _mapCopy(o.parameters);
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        /**
         * API name: {@code include_output_in_agent_response}
         */
        @Nonnull
        public final Builder includeOutputInAgentResponse(@Nullable Boolean value) {
            this.includeOutputInAgentResponse = value;
            return this;
        }

        /**
         *
         * <p>
         * Adds all elements of <code>map</code> to <code>metadata</code>.
         * </p>
         */
        @Nonnull
        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = _mapPutAll(this.metadata, map);
            return this;
        }

        /**
         *
         * <p>
         * Adds an entry to <code>metadata</code>.
         * </p>
         */
        @Nonnull
        public final Builder metadata(String key, JsonData value) {
            this.metadata = _mapPut(this.metadata, key, value);
            return this;
        }

        /**
         * API name: {@code name}
         */
        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        /**
         * API name: {@code parameters}
         *
         * <p>
         * Adds all elements of <code>map</code> to <code>parameters</code>.
         * </p>
         */
        @Nonnull
        public final Builder parameters(Map<String, JsonData> map) {
            this.parameters = _mapPutAll(this.parameters, map);
            return this;
        }

        /**
         * API name: {@code parameters}
         *
         * <p>
         * Adds an entry to <code>parameters</code>.
         * </p>
         */
        @Nonnull
        public final Builder parameters(String key, JsonData value) {
            this.parameters = _mapPut(this.parameters, key, value);
            return this;
        }

        /**
         * API name: {@code type}
         */
        @Nonnull
        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        /**
         * Builds a {@link ToolItems}.
         *
         * @throws NullPointerException if some of the required fields are null.
         */
        @Override
        @Nonnull
        public ToolItems build() {
            _checkSingleUse();

            return new ToolItems(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Json deserializer for {@link ToolItems}
     */
    public static final JsonpDeserializer<ToolItems> _DESERIALIZER = ObjectBuilderDeserializer.lazy(
        Builder::new,
        ToolItems::setupToolItemsDeserializer
    );

    protected static void setupToolItemsDeserializer(ObjectDeserializer<ToolItems.Builder> op) {
        op.add(Builder::includeOutputInAgentResponse, JsonpDeserializer.booleanDeserializer(), "include_output_in_agent_response");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::parameters, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "parameters");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (builder.metadata == null) {
                builder.metadata = new HashMap<>();
            }
            builder.metadata.put(name, JsonData._DESERIALIZER.deserialize(parser, mapper));
        });
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.includeOutputInAgentResponse);
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || this.getClass() != o.getClass()) return false;
        ToolItems other = (ToolItems) o;
        return Objects.equals(this.includeOutputInAgentResponse, other.includeOutputInAgentResponse)
            && Objects.equals(this.metadata, other.metadata)
            && Objects.equals(this.name, other.name)
            && Objects.equals(this.parameters, other.parameters)
            && Objects.equals(this.type, other.type);
    }
}
