/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class ElisionTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> articles;
    private final boolean articlesCase;
    public static final JsonpDeserializer<ElisionTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ElisionTokenFilter::setupElisionTokenFilterDeserializer);

    private ElisionTokenFilter(Builder builder) {
        super(builder);
        this.articles = ApiTypeHelper.unmodifiableRequired(builder.articles, (Object)this, "articles");
        this.articlesCase = ApiTypeHelper.requireNonNull(builder.articlesCase, this, "articlesCase");
    }

    public static ElisionTokenFilter of(Function<Builder, ObjectBuilder<ElisionTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Elision;
    }

    public final List<String> articles() {
        return this.articles;
    }

    public final boolean articlesCase() {
        return this.articlesCase;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "elision");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.articles)) {
            generator.writeKey("articles");
            generator.writeStartArray();
            for (String item0 : this.articles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("articles_case");
        generator.write(this.articlesCase);
    }

    protected static void setupElisionTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        ElisionTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::articles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "articles");
        op.add(Builder::articlesCase, JsonpDeserializer.booleanDeserializer(), "articles_case");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ElisionTokenFilter> {
        private List<String> articles;
        private Boolean articlesCase;

        public final Builder articles(List<String> list) {
            this.articles = Builder._listAddAll(this.articles, list);
            return this;
        }

        public final Builder articles(String value, String ... values) {
            this.articles = Builder._listAdd(this.articles, value, values);
            return this;
        }

        public final Builder articlesCase(boolean value) {
            this.articlesCase = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ElisionTokenFilter build() {
            this._checkSingleUse();
            return new ElisionTokenFilter(this);
        }
    }
}

