/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.reroute;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RerouteParameters
implements PlainJsonSerializable {
    private final boolean allowPrimary;
    private final String index;
    private final String node;
    private final int shard;
    @Nullable
    private final String fromNode;
    @Nullable
    private final String toNode;
    public static final JsonpDeserializer<RerouteParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteParameters::setupRerouteParametersDeserializer);

    private RerouteParameters(Builder builder) {
        this.allowPrimary = ApiTypeHelper.requireNonNull(builder.allowPrimary, this, "allowPrimary");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.shard = ApiTypeHelper.requireNonNull(builder.shard, this, "shard");
        this.fromNode = builder.fromNode;
        this.toNode = builder.toNode;
    }

    public static RerouteParameters of(Function<Builder, ObjectBuilder<RerouteParameters>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean allowPrimary() {
        return this.allowPrimary;
    }

    public final String index() {
        return this.index;
    }

    public final String node() {
        return this.node;
    }

    public final int shard() {
        return this.shard;
    }

    @Nullable
    public final String fromNode() {
        return this.fromNode;
    }

    @Nullable
    public final String toNode() {
        return this.toNode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allow_primary");
        generator.write(this.allowPrimary);
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("shard");
        generator.write(this.shard);
        if (this.fromNode != null) {
            generator.writeKey("from_node");
            generator.write(this.fromNode);
        }
        if (this.toNode != null) {
            generator.writeKey("to_node");
            generator.write(this.toNode);
        }
    }

    protected static void setupRerouteParametersDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowPrimary, JsonpDeserializer.booleanDeserializer(), "allow_primary");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
        op.add(Builder::fromNode, JsonpDeserializer.stringDeserializer(), "from_node");
        op.add(Builder::toNode, JsonpDeserializer.stringDeserializer(), "to_node");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RerouteParameters> {
        private Boolean allowPrimary;
        private String index;
        private String node;
        private Integer shard;
        @Nullable
        private String fromNode;
        @Nullable
        private String toNode;

        public final Builder allowPrimary(boolean value) {
            this.allowPrimary = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public final Builder fromNode(@Nullable String value) {
            this.fromNode = value;
            return this;
        }

        public final Builder toNode(@Nullable String value) {
            this.toNode = value;
            return this;
        }

        @Override
        public RerouteParameters build() {
            this._checkSingleUse();
            return new RerouteParameters(this);
        }
    }
}

