/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IAdductFormula;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;

public class AdductFormula
implements Iterable<IMolecularFormula>,
IAdductFormula,
Cloneable {
    private static final long serialVersionUID = -811384981700039389L;
    private List<IMolecularFormula> components = new ArrayList<IMolecularFormula>();

    public AdductFormula() {
    }

    public AdductFormula(IMolecularFormula formula) {
        this.components.add(0, formula);
    }

    public void addMolecularFormula(IMolecularFormula formula) {
        this.components.add(formula);
    }

    public void add(IMolecularFormulaSet formulaSet) {
        for (IMolecularFormula mf : formulaSet.molecularFormulas()) {
            this.addMolecularFormula(mf);
        }
    }

    public boolean contains(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            return true;
        }
        return false;
    }

    public Integer getCharge() {
        Integer charge = 0;
        Iterator<IMolecularFormula> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            charge = charge + componentIterator.next().getCharge();
        }
        return charge;
    }

    public int getIsotopeCount(IIsotope isotope) {
        int count = 0;
        Iterator<IMolecularFormula> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            count += componentIterator.next().getIsotopeCount(isotope);
        }
        return count;
    }

    public int getIsotopeCount() {
        return this.isotopesList().size();
    }

    public Iterable<IIsotope> isotopes() {
        return new Iterable<IIsotope>(){

            @Override
            public Iterator<IIsotope> iterator() {
                return AdductFormula.this.isotopesList().iterator();
            }
        };
    }

    private List<IIsotope> isotopesList() {
        ArrayList<IIsotope> isotopes = new ArrayList<IIsotope>();
        Iterator<IMolecularFormula> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            for (IIsotope isotope : componentIterator.next().isotopes()) {
                if (isotopes.contains(isotope)) continue;
                isotopes.add(isotope);
            }
        }
        return isotopes;
    }

    public void setCharge(Integer charge) {
        throw new IllegalAccessError();
    }

    public Iterable<IMolecularFormula> molecularFormulas() {
        return this.components;
    }

    @Override
    public Iterator<IMolecularFormula> iterator() {
        return this.components.iterator();
    }

    public int size() {
        return this.components.size();
    }

    public boolean contains(IMolecularFormula formula) {
        return this.components.contains(formula);
    }

    public IMolecularFormula getMolecularFormula(int position) {
        return this.components.get(position);
    }

    public void removeAllMolecularFormulas() {
        this.components.clear();
    }

    public void removeMolecularFormula(IMolecularFormula formula) {
        this.components.remove(formula);
    }

    public void removeMolecularFormula(int position) {
        this.components.remove(position);
    }

    public Object clone() throws CloneNotSupportedException {
        AdductFormula clone = new AdductFormula();
        for (IMolecularFormula form : this.molecularFormulas()) {
            clone.addMolecularFormula((IMolecularFormula)form.clone());
        }
        return clone;
    }

    private boolean isTheSame(IIsotope isotopeOne, IIsotope isotopeTwo) {
        if (!Objects.equals(isotopeOne.getSymbol(), isotopeTwo.getSymbol())) {
            return false;
        }
        if (!Objects.equals(isotopeOne.getNaturalAbundance(), isotopeTwo.getNaturalAbundance())) {
            return false;
        }
        return Objects.equals(isotopeOne.getExactMass(), isotopeTwo.getExactMass());
    }

    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }
}

