/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.criterion;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.xmlsec.SignatureValidationConfiguration;

public class SignatureValidationConfigurationCriterion
implements Criterion {
    private List<SignatureValidationConfiguration> configs;

    public SignatureValidationConfigurationCriterion(@Nonnull @NonnullElements @NotEmpty List<SignatureValidationConfiguration> configurations) {
        Constraint.isNotNull(configurations, (String)"List of configurations may not be null");
        this.configs = Lists.newArrayList((Iterable)Collections2.filter(configurations, (Predicate)Predicates.notNull()));
        Constraint.isGreaterThanOrEqual((long)1L, (long)this.configs.size(), (String)"At least one configuration is required");
    }

    public SignatureValidationConfigurationCriterion(SignatureValidationConfiguration ... configurations) {
        Constraint.isNotNull((Object)configurations, (String)"List of configurations may not be null");
        this.configs = Lists.newArrayList((Iterable)Collections2.filter(Arrays.asList(configurations), (Predicate)Predicates.notNull()));
        Constraint.isGreaterThanOrEqual((long)1L, (long)this.configs.size(), (String)"At least one configuration is required");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    @NotEmpty
    public List<SignatureValidationConfiguration> getConfigurations() {
        return ImmutableList.copyOf(this.configs);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SignatureValidationConfigurationCriterion [configs=");
        builder.append(this.configs);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SignatureValidationConfigurationCriterion) {
            return this.configs.equals(((SignatureValidationConfigurationCriterion)obj).getConfigurations());
        }
        return false;
    }
}

