/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.testing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.QNameSupport;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public abstract class XMLObjectBaseTestCase
extends OpenSAMLInitBaseTestCase {
    protected static ParserPool parserPool;
    protected static XMLObjectBuilderFactory builderFactory;
    protected static MarshallerFactory marshallerFactory;
    protected static UnmarshallerFactory unmarshallerFactory;
    @Nonnull
    protected static QName simpleXMLObjectQName;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(XMLObjectBaseTestCase.class);

    @BeforeClass
    protected void initXMLObjectSupport() throws Exception {
        try {
            parserPool = XMLObjectProviderRegistrySupport.getParserPool();
            builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
        }
        catch (Exception e) {
            this.log.error("Can not initialize XMLObjectBaseTestCase: {}", (Object)e.getMessage());
            throw e;
        }
    }

    protected void assertXMLEquals(Document expectedDOM, @Nonnull XMLObject xmlObject) {
        this.assertXMLEquals("Marshalled DOM was not the same as the expected DOM", expectedDOM, xmlObject);
    }

    protected void assertXMLEquals(String failMessage, Document expectedDOM, XMLObject xmlObject) {
        assert (xmlObject != null);
        Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
        if (marshaller == null) {
            Assert.fail((String)("Unable to locate marshaller for " + String.valueOf(xmlObject.getElementQName()) + " can not perform equality check assertion"));
        }
        assert (marshaller != null);
        try {
            Element generatedDOM = marshaller.marshall(xmlObject, parserPool.newDocument());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Marshalled DOM was " + SerializeSupport.nodeToString((Node)generatedDOM));
            }
            Diff diff = DiffBuilder.compare((Object)expectedDOM).withTest((Object)generatedDOM.getOwnerDocument()).ignoreWhitespace().checkForIdentical().build();
            Assert.assertFalse((boolean)diff.hasDifferences(), (String)failMessage);
        }
        catch (Exception e) {
            Assert.fail((String)("Marshalling failed with the following error: " + String.valueOf(e)));
        }
    }

    @Nonnull
    protected <T extends XMLObject> T buildXMLObject(@Nonnull QName name) {
        XMLObjectBuilder<T> builder = this.getBuilder(name);
        XMLObject wsObj = builder.buildObject(name);
        Assert.assertNotNull((Object)wsObj);
        return (T)wsObj;
    }

    @Nullable
    protected <T extends XMLObject> T unmarshallElement(@Nonnull String elementFile) {
        try {
            return this.unmarshallElement(elementFile, false);
        }
        catch (XMLParserException | UnmarshallingException e) {
            Assert.fail((String)("Unable to parse or unmarshall element file " + elementFile + ": " + String.valueOf(e)));
            return null;
        }
    }

    @Nullable
    protected <T extends XMLObject> T unmarshallElement(@Nonnull String elementFile, boolean propagateErrors) throws XMLParserException, UnmarshallingException {
        try {
            Document doc = this.parseXMLDocument(elementFile);
            Element element = doc.getDocumentElement();
            Unmarshaller unmarshaller = this.getUnmarshaller(element);
            XMLObject object = unmarshaller.unmarshall(element);
            Assert.assertNotNull((Object)object);
            return (T)object;
        }
        catch (XMLParserException e) {
            if (propagateErrors) {
                throw e;
            }
            Assert.fail((String)("Unable to parse element file " + elementFile));
        }
        catch (UnmarshallingException e) {
            if (propagateErrors) {
                throw e;
            }
            Assert.fail((String)("Unmarshalling failed when parsing element file " + elementFile + ": " + String.valueOf((Object)e)));
        }
        return null;
    }

    protected void printXML(@Nonnull Node node, @Nonnull String filename) {
        try {
            SerializeSupport.writeNode((Node)node, (OutputStream)new FileOutputStream(new File(filename)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void printXML(@Nonnull XMLObject xmlObject, @Nonnull String filename) {
        Element elem = null;
        try {
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            assert (marshaller != null);
            elem = marshaller.marshall(xmlObject);
        }
        catch (MarshallingException e) {
            e.printStackTrace();
        }
        assert (elem != null);
        this.printXML(elem, filename);
    }

    @Nonnull
    protected <T extends XMLObject> XMLObjectBuilder<T> getBuilder(@Nonnull QName qname) {
        return builderFactory.ensureBuilder(qname);
    }

    @Nonnull
    protected Marshaller getMarshaller(@Nonnull QName qname) {
        return marshallerFactory.ensureMarshaller(qname);
    }

    @Nonnull
    protected Marshaller getMarshaller(@Nonnull XMLObject xmlObject) {
        return marshallerFactory.ensureMarshaller(xmlObject);
    }

    @Nonnull
    protected Unmarshaller getUnmarshaller(@Nonnull QName qname) {
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(qname);
        if (unmarshaller == null) {
            Assert.fail((String)("no unmarshaller registered for " + String.valueOf(qname)));
        }
        assert (unmarshaller != null);
        return unmarshaller;
    }

    @Nonnull
    protected Unmarshaller getUnmarshaller(@Nonnull XMLObject xmlObject) {
        return this.getUnmarshaller(xmlObject.getElementQName());
    }

    @Nonnull
    protected Unmarshaller getUnmarshaller(@Nonnull Element element) {
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
        if (unmarshaller == null) {
            Assert.fail((String)("no unmarshaller registered for " + String.valueOf(QNameSupport.getNodeQName((Node)element))));
        }
        assert (unmarshaller != null);
        return unmarshaller;
    }

    @Nonnull
    protected Document parseXMLDocument(@Nonnull String xmlFilename) throws XMLParserException {
        InputStream is = this.getClass().getResourceAsStream(xmlFilename);
        assert (is != null);
        Document doc = parserPool.parse(is);
        return doc;
    }

    static {
        simpleXMLObjectQName = new QName("http://www.example.org/testObjects", "SimpleElement");
    }
}

