/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.testing;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.InitializableComponent;
import org.opensaml.storage.EnumeratableStorageService;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.VersionMismatchException;
import org.opensaml.storage.annotation.Context;
import org.opensaml.storage.annotation.Expiration;
import org.opensaml.storage.annotation.Key;
import org.opensaml.storage.annotation.Value;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class StorageServiceTest {
    protected SecureRandom random;
    protected EnumeratableStorageService shared;

    @Nonnull
    protected abstract EnumeratableStorageService getStorageService();

    protected void threadInit() {
    }

    @BeforeClass
    protected void setUp() throws ComponentInitializationException {
        this.random = new SecureRandom();
        this.shared = this.getStorageService();
        if (this.shared instanceof InitializableComponent) {
            ((InitializableComponent)this.shared).initialize();
        }
    }

    @AfterClass
    protected void tearDown() {
        if (this.shared instanceof DestructableComponent) {
            ((DestructableComponent)this.shared).destroy();
        }
    }

    @Test(threadPoolSize=10, invocationCount=10)
    public void strings() throws IOException {
        int i;
        this.threadInit();
        String context = Long.toString(this.random.nextLong());
        for (int i2 = 1; i2 <= 100; ++i2) {
            boolean result = this.shared.create(context, Integer.toString(i2), Integer.toString(i2 + 1), Long.valueOf(System.currentTimeMillis() + 300000L));
            Assert.assertTrue((boolean)result);
        }
        ArrayList keylist = new ArrayList();
        Iterable keys = this.shared.getContextKeys(context, null);
        keys.forEach(keylist::add);
        Assert.assertEquals((int)keylist.size(), (int)100);
        for (i = 1; i <= 100; ++i) {
            StorageRecord rec = this.shared.read(context, Integer.toString(i));
            assert (rec != null);
            Assert.assertEquals((String)rec.getValue(), (String)Integer.toString(i + 1));
        }
        for (i = 1; i <= 100; ++i) {
            boolean result = this.shared.update(context, Integer.toString(i), Integer.toString(i + 2), Long.valueOf(System.currentTimeMillis() + 300000L));
            Assert.assertTrue((boolean)result);
        }
        for (i = 1; i <= 100; ++i) {
            StorageRecord rec = this.shared.read(context, Integer.toString(i));
            assert (rec != null);
            Assert.assertEquals((String)rec.getValue(), (String)Integer.toString(i + 2));
        }
        for (i = 1; i <= 100; ++i) {
            boolean result = this.shared.create(context, Integer.toString(i), Integer.toString(i + 1), null);
            Assert.assertFalse((boolean)result, (String)"createString should have failed");
        }
        for (i = 1; i <= 100; ++i) {
            this.shared.delete(context, Integer.toString(i));
            StorageRecord rec = this.shared.read(context, Integer.toString(i));
            Assert.assertNull((Object)rec);
        }
        keylist.clear();
        keys = this.shared.getContextKeys(context, null);
        keys.forEach(keylist::add);
        Assert.assertEquals((int)keylist.size(), (int)0);
    }

    @Test
    public void expiration() throws IOException, InterruptedException {
        int i;
        this.threadInit();
        String context = Long.toString(this.random.nextLong());
        for (i = 1; i <= 100; ++i) {
            this.shared.create(context, Integer.toString(i), Integer.toString(i + 1), Long.valueOf(System.currentTimeMillis() + 5000L));
        }
        Thread.sleep(5150L);
        for (i = 1; i <= 100; ++i) {
            StorageRecord rec = this.shared.read(context, Integer.toString(i));
            Assert.assertNull((Object)rec);
        }
        Assert.assertFalse((boolean)this.shared.getContextKeys(context, null).iterator().hasNext());
    }

    @Test
    public void versions() throws IOException, VersionMismatchException {
        this.threadInit();
        String key = "key";
        String context = Long.toString(this.random.nextLong());
        this.shared.create(context, "key", "foo", null);
        for (long i = 1L; i < 130L; ++i) {
            this.shared.updateWithVersion(i, context, "key", "foo" + i, null);
        }
        StorageRecord rec = this.shared.read(context, "key");
        assert (rec != null);
        Assert.assertEquals((long)rec.getVersion(), (long)130L);
        Assert.assertEquals((String)rec.getValue(), (String)"foo129");
    }

    @Test
    public void update() throws IOException {
        String context = Long.toString(this.random.nextLong());
        String value = Long.toString(this.random.nextLong());
        String newValue = Long.toString(this.random.nextLong());
        Long expiration = System.currentTimeMillis() + 10000L;
        this.shared.create(context, context, value, expiration);
        StorageRecord rec = this.shared.read(context, context);
        assert (rec != null);
        Assert.assertEquals((String)rec.getValue(), (String)value);
        Assert.assertEquals((Long)rec.getExpiration(), (Long)expiration);
        this.shared.updateExpiration(context, context, Long.valueOf(expiration + 50000L));
        rec = this.shared.read(context, context);
        assert (rec != null);
        Assert.assertEquals((String)rec.getValue(), (String)value);
        Assert.assertNotEquals((Object)rec.getExpiration(), (Object)expiration);
        this.shared.update(context, context, newValue, Long.valueOf(expiration + 100000L));
        rec = this.shared.read(context, context);
        assert (rec != null);
        Assert.assertEquals((String)rec.getValue(), (String)newValue);
        Assert.assertNotEquals((Object)rec.getExpiration(), (Object)expiration);
    }

    @Test
    public void objects() throws IOException, InterruptedException {
        this.threadInit();
        AnnotatedObject o1 = new AnnotatedObject();
        AnnotatedObject o2 = new AnnotatedObject();
        o1.generate();
        this.shared.create((Object)o1);
        o2.setContext(o1.getContext());
        o2.setKey(o1.getKey());
        Assert.assertSame((Object)o2, (Object)this.shared.read((Object)o2));
        Assert.assertEquals((String)o1.getValue(), (String)o2.getValue());
        o2.setValue("foo");
        o2.setExpiration(System.currentTimeMillis() + 10000L);
        this.shared.update((Object)o2);
        this.shared.read((Object)o1);
        Assert.assertEquals((String)o1.getValue(), (String)"foo");
        Assert.assertEquals((long)o1.getExpiration(), (long)o2.getExpiration());
        Thread.sleep(10100L);
        Assert.assertNull((Object)this.shared.read((Object)o2));
    }

    @Test
    public void enumerate() throws IOException {
        String context = "zork";
        this.shared.create("zork", "foo", "bar", null);
        this.shared.create("zork", "foo2", "bar", null);
        this.shared.create("zork", "foo3", "bar", null);
        this.shared.create("zork", "foo33", "bar", null);
        this.shared.create("zork2", "foo3", "bar", null);
        ArrayList copy = new ArrayList();
        Iterable keys = this.shared.getContextKeys("zork", null);
        keys.forEach(copy::add);
        Assert.assertEquals((int)copy.size(), (int)4);
        copy.clear();
        keys = this.shared.getContextKeys("zork", "foo");
        keys.forEach(copy::add);
        Assert.assertEquals((int)copy.size(), (int)4);
        copy.clear();
        keys = this.shared.getContextKeys("zork", "foo3");
        keys.forEach(copy::add);
        Assert.assertEquals((int)copy.size(), (int)2);
    }

    @Context(value="context")
    @Key(value="key")
    @Value(value="value")
    @Expiration(value="expiration")
    private class AnnotatedObject {
        private String context;
        private String key;
        private String value;
        private Long expiration;

        private AnnotatedObject() {
        }

        public void generate() {
            this.context = Long.toString(StorageServiceTest.this.random.nextLong());
            this.key = Long.toString(StorageServiceTest.this.random.nextLong());
            this.value = Long.toString(StorageServiceTest.this.random.nextLong());
            this.expiration = System.currentTimeMillis() + 60000L;
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String c) {
            this.context = c;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String k) {
            this.key = k;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String val) {
            this.value = val;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public void setExpiration(long exp) {
            this.expiration = exp;
        }
    }
}

