/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.storage.MutableStorageRecord;
import org.opensaml.storage.impl.client.AbstractClientStorageServiceStore;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.opensaml.storage.impl.client.ClientStorageServiceStore;
import org.slf4j.Logger;

public class JSONClientStorageServiceStore
extends AbstractClientStorageServiceStore {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JSONClientStorageServiceStore.class);

    @Override
    public void doLoad(@Nullable @NotEmpty String raw) throws IOException {
        try {
            JsonReader reader = Json.createReader((Reader)new StringReader(raw));
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new JsonException("Found invalid data structure while parsing context map");
            }
            JsonObject obj = (JsonObject)st;
            for (Map.Entry context : obj.entrySet()) {
                if (((JsonValue)context.getValue()).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new JsonException("Found invalid data structure while parsing context map");
                }
                Map<String, MutableStorageRecord<?>> dataMap = this.getContextMap().get(context.getKey());
                if (dataMap == null) {
                    dataMap = new HashMap();
                    this.getContextMap().put((String)context.getKey(), dataMap);
                }
                JsonObject contextRecords = (JsonObject)context.getValue();
                for (Map.Entry record : contextRecords.entrySet()) {
                    JsonObject fields = (JsonObject)record.getValue();
                    Long exp = null;
                    if (fields.containsKey((Object)"x")) {
                        exp = fields.getJsonNumber("x").longValueExact();
                    }
                    dataMap.put((String)record.getKey(), new MutableStorageRecord(fields.getString("v"), exp));
                }
            }
            this.setDirty(false);
        }
        catch (JsonException | ArithmeticException | ClassCastException | NullPointerException e) {
            this.log.error("Found invalid data structure while parsing context map", e);
            throw new IOException(e);
        }
    }

    @Override
    @Nullable
    public ClientStorageServiceOperation save(@Nonnull ClientStorageService storageService) throws IOException {
        if (!this.isDirty()) {
            this.log.trace("{} Storage state has not been modified, save operation skipped", (Object)storageService.getLogPrefix());
            return null;
        }
        ClientStorageService.ClientStorageSource source = this.getSource();
        if (source == null) {
            throw new IOException("Client storage medium not set");
        }
        if (this.getContextMap().isEmpty()) {
            this.log.trace("{} Data is empty", (Object)storageService.getLogPrefix());
            return new ClientStorageServiceOperation(storageService.ensureId(), storageService.getStorageName(), null, source);
        }
        long exp = 0L;
        long now = System.currentTimeMillis();
        boolean empty = true;
        try {
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = Json.createGenerator((Writer)sink);
            gen.writeStartObject();
            for (Map.Entry<String, Map<String, MutableStorageRecord<?>>> context : this.getContextMap().entrySet()) {
                if (context.getValue().isEmpty()) continue;
                gen.writeStartObject(context.getKey());
                for (Map.Entry<String, MutableStorageRecord<?>> entry : context.getValue().entrySet()) {
                    MutableStorageRecord<?> record = entry.getValue();
                    Long recexp = record.getExpiration();
                    if (recexp != null && recexp <= now) continue;
                    empty = false;
                    gen.writeStartObject(entry.getKey()).write("v", record.getValue());
                    if (recexp != null) {
                        gen.write("x", recexp.longValue());
                        exp = Math.max(exp, recexp);
                    }
                    gen.writeEnd();
                }
                gen.writeEnd();
            }
            gen.writeEnd().close();
            if (empty) {
                this.log.trace("{} Data is empty", (Object)storageService.getLogPrefix());
                return new ClientStorageServiceOperation(storageService.getId(), storageService.getStorageName(), null, source);
            }
            String raw = sink.toString();
            this.log.trace("{} Size of data before encryption is {}", (Object)storageService.getLogPrefix(), (Object)raw.length());
            this.log.trace("{} Data before encryption is {}", (Object)storageService.getLogPrefix(), (Object)raw);
            try {
                String wrapped = storageService.getDataSealer().wrap(raw, exp > 0L ? Instant.ofEpochMilli(exp) : Instant.now().plus(Duration.ofDays(1L)));
                this.log.trace("{} Size of data after encryption is {}", (Object)storageService.getLogPrefix(), (Object)wrapped.length());
                this.setDirty(false);
                return new ClientStorageServiceOperation(storageService.getId(), storageService.getStorageName(), wrapped, source);
            }
            catch (DataSealerException e) {
                throw new IOException(e);
            }
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }

    public static class JSONClientStorageServiceStoreFactory
    implements ClientStorageServiceStore.Factory {
        @Override
        @Nonnull
        public ClientStorageServiceStore load(@Nullable @NotEmpty String raw, @Nonnull ClientStorageService.ClientStorageSource src) {
            JSONClientStorageServiceStore store = new JSONClientStorageServiceStore();
            store.load(raw, src);
            return store;
        }
    }
}

