/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.Connection;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.ext.MergeOperation;
import org.ldaptive.ext.MergeRequest;
import org.ldaptive.pool.PooledConnectionFactory;
import org.opensaml.storage.AbstractStorageService;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPStorageService
extends AbstractStorageService {
    private final Logger log = LoggerFactory.getLogger(LDAPStorageService.class);
    private PooledConnectionFactory connectionFactory;
    private LdapAttribute[] defaultAttributes;

    public LDAPStorageService(@Nonnull PooledConnectionFactory factory, LdapAttribute ... attrs) {
        this.connectionFactory = (PooledConnectionFactory)Constraint.isNotNull((Object)factory, (String)"ConnectionFactory cannot be null");
        this.defaultAttributes = attrs;
        this.setContextSize(Integer.MAX_VALUE);
        this.setKeySize(Integer.MAX_VALUE);
        this.setValueSize(Integer.MAX_VALUE);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.connectionFactory.getConnectionPool().initialize();
    }

    protected void doDestroy() {
        super.doDestroy();
        if (this.isInitialized()) {
            this.connectionFactory.getConnectionPool().close();
            this.connectionFactory = null;
        }
    }

    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        if (expiration != null) {
            throw new UnsupportedOperationException("Expiration not supported");
        }
        LdapEntry entry = new LdapEntry(context, this.defaultAttributes);
        entry.addAttribute(new LdapAttribute[]{new LdapAttribute(key, new String[]{value})});
        try {
            this.merge(entry);
            return true;
        }
        catch (LdapException e) {
            this.log.error("LDAP merge operation failed", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Nullable
    public StorageRecord read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        LdapAttribute attr;
        LdapEntry entry;
        SearchResult result;
        block3: {
            result = null;
            try {
                result = (SearchResult)this.search(context, key).getResult();
            }
            catch (LdapException e) {
                if (e.getResultCode() == ResultCode.NO_SUCH_OBJECT) break block3;
                this.log.error("LDAP search operation failed", (Throwable)e);
                throw new IOException(e);
            }
        }
        StorageRecord record = null;
        if (result != null && result.size() > 0 && (entry = result.getEntry()) != null && (attr = entry.getAttribute(key)) != null) {
            record = new StorageRecord(attr.getStringValue(), null);
        }
        return record;
    }

    @Nonnull
    public Pair<Integer, StorageRecord> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive int version) throws IOException {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    @Nullable
    public Integer update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        if (expiration != null) {
            throw new UnsupportedOperationException("Expiration not supported");
        }
        LdapEntry entry = new LdapEntry(context, this.defaultAttributes);
        entry.addAttribute(new LdapAttribute[]{new LdapAttribute(key, new String[]{value})});
        try {
            this.merge(entry);
            return null;
        }
        catch (LdapException e) {
            this.log.error("LDAP merge operation failed", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Nullable
    public Integer updateWithVersion(@Positive int version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    @Nullable
    public Integer updateExpiration(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable @Positive Long expiration) throws IOException {
        throw new UnsupportedOperationException("Expiration not supported");
    }

    public boolean delete(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        try {
            this.deleteAttribute(context, key);
            return true;
        }
        catch (LdapException e) {
            this.log.error("LDAP modify operation failed", (Throwable)e);
            throw new IOException(e);
        }
    }

    public boolean deleteWithVersion(@Positive int version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    public void reap(@Nonnull @NotEmpty String context) throws IOException {
    }

    public void updateContextExpiration(@Nonnull @NotEmpty String context, @Nullable @Positive Long expiration) throws IOException {
        throw new UnsupportedOperationException("Expiration not supported");
    }

    public void deleteContext(@Nonnull @NotEmpty String context) throws IOException {
        try {
            this.delete(context);
        }
        catch (LdapException e) {
            this.log.error("LDAP delete operation failed", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Response<Void> merge(@Nonnull LdapEntry entry) throws LdapException {
        try (Connection conn = null;){
            conn = this.connectionFactory.getConnection();
            MergeOperation merge = new MergeOperation(conn);
            MergeRequest request = new MergeRequest(entry);
            request.setIncludeAttributes(entry.getAttributeNames());
            Response response = merge.execute((Request)request);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Response<SearchResult> search(@Nonnull String dn, String ... attrs) throws LdapException {
        try (Connection conn = null;){
            conn = this.connectionFactory.getConnection();
            SearchOperation search = new SearchOperation(conn);
            Response response = search.execute((Request)SearchRequest.newObjectScopeSearchRequest((String)dn, (String[])attrs));
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Response<Void> deleteAttribute(@Nonnull String dn, @Nonnull String attrName) throws LdapException {
        try (Connection conn = null;){
            conn = this.connectionFactory.getConnection();
            ModifyOperation modify = new ModifyOperation(conn);
            Response response = modify.execute((Request)new ModifyRequest(dn, new AttributeModification[]{new AttributeModification(AttributeModificationType.REMOVE, new LdapAttribute(attrName))}));
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Response<Void> delete(@Nonnull String dn) throws LdapException {
        try (Connection conn = null;){
            conn = this.connectionFactory.getConnection();
            DeleteOperation delete = new DeleteOperation(conn);
            Response response = delete.execute((Request)new DeleteRequest(dn));
            return response;
        }
    }
}

