/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.storage.AbstractMapBackedStorageService;
import org.opensaml.storage.MutableStorageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStorageService
extends AbstractMapBackedStorageService {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MemoryStorageService.class);
    @NonnullAfterInit
    @NonnullElements
    private Map<String, Map<String, MutableStorageRecord>> contextMap;
    @NonnullAfterInit
    private ReadWriteLock lock;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.contextMap = Maps.newHashMap();
        this.lock = new ReentrantReadWriteLock(true);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.contextMap = null;
        this.lock = null;
    }

    @Nonnull
    @NonnullElements
    @Live
    protected Map<String, Map<String, MutableStorageRecord>> getContextMap() {
        return this.contextMap;
    }

    @Nonnull
    protected ReadWriteLock getLock() {
        return this.lock;
    }

    @Nullable
    protected TimerTask getCleanupTask() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MemoryStorageService.this.log.info("Running cleanup task");
                Long now = System.currentTimeMillis();
                Lock writeLock = MemoryStorageService.this.getLock().writeLock();
                boolean purged = false;
                try {
                    writeLock.lock();
                    Collection<Map<String, MutableStorageRecord>> contexts = MemoryStorageService.this.getContextMap().values();
                    Iterator<Map<String, MutableStorageRecord>> i = contexts.iterator();
                    while (i.hasNext()) {
                        Map<String, MutableStorageRecord> context = i.next();
                        if (!MemoryStorageService.this.reapWithLock(context, now)) continue;
                        purged = true;
                        if (!context.isEmpty()) continue;
                        i.remove();
                    }
                }
                finally {
                    writeLock.unlock();
                }
                if (purged) {
                    MemoryStorageService.this.log.info("Purged expired record(s) from storage");
                } else {
                    MemoryStorageService.this.log.info("No expired records found in storage");
                }
            }
        };
    }
}

