/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.opensaml.storage.annotation.AnnotationSupport;

public abstract class AbstractStorageService
extends AbstractIdentifiableInitializableComponent
implements StorageService,
StorageCapabilities {
    @Duration
    @NonNegative
    private long cleanupInterval;
    private Timer cleanupTaskTimer;
    private Timer internalTaskTimer;
    private TimerTask cleanupTask;
    @Positive
    private int contextSize;
    @Positive
    private int keySize;
    @Positive
    private int valueSize;

    public AbstractStorageService() {
        this.setId(this.getClass().getName());
    }

    @NonNegative
    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public synchronized void setCleanupInterval(@Duration @NonNegative long interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cleanupInterval = Constraint.isGreaterThanOrEqual((long)0L, (long)interval, (String)"Cleanup interval must be greater than or equal to zero");
    }

    @Nullable
    public Timer getCleanupTaskTimer() {
        return this.cleanupTaskTimer;
    }

    public synchronized void setCleanupTaskTimer(@Nullable Timer timer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cleanupTaskTimer = timer;
    }

    @Nullable
    protected TimerTask getCleanupTask() {
        return null;
    }

    public void setContextSize(@Positive int size) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.contextSize = (int)Constraint.isGreaterThan((long)0L, (long)size, (String)"Size must be greater than zero");
    }

    public void setKeySize(@Positive int size) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.keySize = (int)Constraint.isGreaterThan((long)0L, (long)size, (String)"Size must be greater than zero");
    }

    public void setValueSize(@Positive int size) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.valueSize = (int)Constraint.isGreaterThan((long)0L, (long)size, (String)"Size must be greater than zero");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cleanupInterval > 0L) {
            this.cleanupTask = this.getCleanupTask();
            if (this.cleanupTask == null) {
                throw new ComponentInitializationException("Cleanup task cannot be null if cleanupInterval is set.");
            }
            this.internalTaskTimer = this.cleanupTaskTimer == null ? new Timer() : this.cleanupTaskTimer;
            this.internalTaskTimer.schedule(this.cleanupTask, this.cleanupInterval * 1000L, this.cleanupInterval * 1000L);
        }
    }

    protected void doDestroy() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
            if (this.cleanupTaskTimer == null) {
                this.internalTaskTimer.cancel();
            }
            this.internalTaskTimer = null;
        }
        super.doDestroy();
    }

    @Override
    @Nonnull
    public StorageCapabilities getCapabilities() {
        return this;
    }

    @Override
    public int getContextSize() {
        return this.contextSize;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public long getValueSize() {
        return this.valueSize;
    }

    @Override
    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull Object value, @Nonnull StorageSerializer serializer, @Nullable @Positive Long expiration) throws IOException {
        return this.create(context, key, serializer.serialize(value), expiration);
    }

    @Override
    public boolean create(@Nonnull Object value) throws IOException {
        return this.create(AnnotationSupport.getContext(value), AnnotationSupport.getKey(value), AnnotationSupport.getValue(value), AnnotationSupport.getExpiration(value));
    }

    @Override
    @Nullable
    public Object read(@Nonnull Object value) throws IOException {
        StorageRecord record = this.read(AnnotationSupport.getContext(value), AnnotationSupport.getKey(value));
        if (record != null) {
            AnnotationSupport.setValue(value, record.getValue());
            AnnotationSupport.setExpiration(value, record.getExpiration());
            return value;
        }
        return null;
    }

    @Override
    @Nullable
    public Integer update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull Object value, @Nonnull StorageSerializer serializer, @Nullable @Positive Long expiration) throws IOException {
        return this.update(context, key, serializer.serialize(value), expiration);
    }

    @Override
    @Nullable
    public Integer updateWithVersion(@Positive int version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull Object value, @Nonnull StorageSerializer serializer, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        return this.updateWithVersion(version, context, key, serializer.serialize(value), expiration);
    }

    @Override
    @Nullable
    public Integer update(@Nonnull Object value) throws IOException {
        return this.update(AnnotationSupport.getContext(value), AnnotationSupport.getKey(value), AnnotationSupport.getValue(value), AnnotationSupport.getExpiration(value));
    }

    @Override
    @Nullable
    public Integer updateWithVersion(@Positive int version, @Nonnull Object value) throws IOException, VersionMismatchException {
        return this.updateWithVersion(version, AnnotationSupport.getContext(value), AnnotationSupport.getKey(value), AnnotationSupport.getValue(value), AnnotationSupport.getExpiration(value));
    }

    @Override
    @Nullable
    public Integer updateExpiration(@Nonnull Object value) throws IOException {
        return this.updateExpiration(AnnotationSupport.getContext(value), AnnotationSupport.getKey(value), AnnotationSupport.getExpiration(value));
    }

    @Override
    public boolean delete(@Nonnull Object value) throws IOException {
        return this.delete(AnnotationSupport.getContext(value), AnnotationSupport.getKey(value));
    }

    @Override
    public boolean deleteWithVersion(@Positive int version, @Nonnull Object value) throws IOException, VersionMismatchException {
        return this.deleteWithVersion(version, AnnotationSupport.getContext(value), AnnotationSupport.getKey(value));
    }
}

