/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.spring.tls;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.httpclient.HttpClientSupport;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.impl.SecurityEnhancedHttpClientSupport;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class TLSSocketFactoryFactoryBean
extends AbstractFactoryBean<LayeredConnectionSocketFactory> {
    @Nullable
    private TrustEngine<?> tlsTrustEngine;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    private boolean connectionDisregardTLSCertificate;

    @Deprecated(since="5.0.0", forRemoval=true)
    public void setTLSTrustEngine(@Nullable TrustEngine<? super X509Credential> engine) {
        this.tlsTrustEngine = engine;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.httpClientSecurityParameters = params;
    }

    public void setConnectionDisregardTLSCertificate(boolean disregard) {
        this.connectionDisregardTLSCertificate = disregard;
    }

    @Nonnull
    public Class<LayeredConnectionSocketFactory> getObjectType() {
        return LayeredConnectionSocketFactory.class;
    }

    @Nonnull
    protected LayeredConnectionSocketFactory createInstance() throws Exception {
        boolean haveClientTLSCred;
        boolean haveTrustEngine = this.tlsTrustEngine != null || this.httpClientSecurityParameters != null && this.httpClientSecurityParameters.getTLSTrustEngine() != null;
        boolean bl = haveClientTLSCred = this.httpClientSecurityParameters != null && this.httpClientSecurityParameters.getClientTLSCredential() != null;
        if (haveTrustEngine || haveClientTLSCred) {
            return SecurityEnhancedHttpClientSupport.buildTLSSocketFactory((boolean)haveTrustEngine, (boolean)haveClientTLSCred);
        }
        if (this.connectionDisregardTLSCertificate) {
            return HttpClientSupport.buildNoTrustTLSSocketFactory();
        }
        return HttpClientSupport.buildStrictTLSSocketFactory();
    }
}

