/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.util;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.ActorBearing;
import org.opensaml.soap.soap11.Detail;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultActor;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.soap12.EncodingStyleBearing;
import org.opensaml.soap.soap12.MustUnderstandBearing;
import org.opensaml.soap.soap12.RelayBearing;
import org.opensaml.soap.soap12.RoleBearing;

public final class SOAPSupport {
    private SOAPSupport() {
    }

    public static void addSOAP11MustUnderstandAttribute(@Nonnull XMLObject soapObject, boolean mustUnderstand) {
        if (soapObject instanceof org.opensaml.soap.soap11.MustUnderstandBearing) {
            ((org.opensaml.soap.soap11.MustUnderstandBearing)soapObject).setSOAP11MustUnderstand(new XSBooleanValue(Boolean.valueOf(mustUnderstand), true));
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(org.opensaml.soap.soap11.MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME, new XSBooleanValue(Boolean.valueOf(mustUnderstand), true).toString());
        } else {
            throw new IllegalArgumentException("Specified object was neither MustUnderstandBearing nor AttributeExtensible");
        }
    }

    public static boolean getSOAP11MustUnderstandAttribute(@Nonnull XMLObject soapObject) {
        Object value;
        if (soapObject instanceof org.opensaml.soap.soap11.MustUnderstandBearing && (value = ((org.opensaml.soap.soap11.MustUnderstandBearing)soapObject).isSOAP11MustUnderstandXSBoolean()) != null) {
            return value.getValue();
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)org.opensaml.soap.soap11.MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME));
            return Objects.equal((Object)"1", (Object)value) || Objects.equal((Object)"true", (Object)value);
        }
        return false;
    }

    public static void addSOAP11ActorAttribute(@Nonnull XMLObject soapObject, @Nonnull String actorURI) {
        String value = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)actorURI), (String)"Actor URI cannot be null or empty");
        if (soapObject instanceof ActorBearing) {
            ((ActorBearing)soapObject).setSOAP11Actor(value);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(ActorBearing.SOAP11_ACTOR_ATTR_NAME, value);
        } else {
            throw new IllegalArgumentException("Specified object was neither ActorBearing nor AttributeExtensible");
        }
    }

    @Nullable
    public static String getSOAP11ActorAttribute(@Nonnull XMLObject soapObject) {
        String value = null;
        if (soapObject instanceof ActorBearing && (value = StringSupport.trimOrNull((String)((ActorBearing)soapObject).getSOAP11Actor())) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)ActorBearing.SOAP11_ACTOR_ATTR_NAME));
            return value;
        }
        return null;
    }

    public static void addSOAP11EncodingStyle(@Nonnull XMLObject soapObject, @Nonnull String encodingStyle) {
        String value = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)encodingStyle), (String)"Encoding style to add cannot be null or empty");
        if (soapObject instanceof org.opensaml.soap.soap11.EncodingStyleBearing) {
            org.opensaml.soap.soap11.EncodingStyleBearing esb = (org.opensaml.soap.soap11.EncodingStyleBearing)soapObject;
            LazyList list = esb.getSOAP11EncodingStyles();
            if (list == null) {
                list = new LazyList();
                esb.setSOAP11EncodingStyles((List<String>)list);
            }
            list.add((String)value);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            AttributeMap am = ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes();
            String list = am.get((Object)org.opensaml.soap.soap11.EncodingStyleBearing.SOAP11_ENCODING_STYLE_ATTR_NAME);
            list = list == null ? value : list + " " + value;
            am.put(org.opensaml.soap.soap11.EncodingStyleBearing.SOAP11_ENCODING_STYLE_ATTR_NAME, list);
        } else {
            throw new IllegalArgumentException("Specified object was neither EncodingStyleBearing nor AttributeExtensible");
        }
    }

    public static void addSOAP11EncodingStyles(@Nonnull XMLObject soapObject, @Nonnull List<String> encodingStyles) {
        Constraint.isNotEmpty(encodingStyles, (String)"Encoding styles list cannot be empty");
        if (soapObject instanceof org.opensaml.soap.soap11.EncodingStyleBearing) {
            ((org.opensaml.soap.soap11.EncodingStyleBearing)soapObject).setSOAP11EncodingStyles(encodingStyles);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(org.opensaml.soap.soap11.EncodingStyleBearing.SOAP11_ENCODING_STYLE_ATTR_NAME, StringSupport.listToStringValue(encodingStyles, (String)" "));
        } else {
            throw new IllegalArgumentException("Specified object was neither EncodingStyleBearing nor AttributeExtensible");
        }
    }

    @Nullable
    public static List<String> getSOAP11EncodingStyles(@Nonnull XMLObject soapObject) {
        Object value;
        if (soapObject instanceof org.opensaml.soap.soap11.EncodingStyleBearing && (value = ((org.opensaml.soap.soap11.EncodingStyleBearing)soapObject).getSOAP11EncodingStyles()) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject && (value = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)org.opensaml.soap.soap11.EncodingStyleBearing.SOAP11_ENCODING_STYLE_ATTR_NAME))) != null) {
            StringSupport.stringToList((String)value, (String)" \n\r\t");
        }
        return null;
    }

    public static void addSOAP12EncodingStyleAttribute(@Nonnull XMLObject soapObject, @Nonnull String style) {
        String value = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)style), (String)"Encoding style to add cannot be null or empty");
        if (soapObject instanceof EncodingStyleBearing) {
            ((EncodingStyleBearing)soapObject).setSOAP12EncodingStyle(value);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(EncodingStyleBearing.SOAP12_ENCODING_STYLE_ATTR_NAME, value);
        } else {
            throw new IllegalArgumentException("Specified object was neither EncodingStyleBearing nor AttribtueExtensible");
        }
    }

    @Nullable
    public static String getSOAP12EncodingStyleAttribute(@Nonnull XMLObject soapObject) {
        String style = null;
        if (soapObject instanceof EncodingStyleBearing) {
            style = ((EncodingStyleBearing)soapObject).getSOAP12EncodingStyle();
        }
        if (style == null && soapObject instanceof AttributeExtensibleXMLObject) {
            style = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)EncodingStyleBearing.SOAP12_ENCODING_STYLE_ATTR_NAME));
        }
        return style;
    }

    public static void addSOAP12MustUnderstandAttribute(@Nonnull XMLObject soapObject, boolean mustUnderstand) {
        if (soapObject instanceof MustUnderstandBearing) {
            ((MustUnderstandBearing)soapObject).setSOAP12MustUnderstand(new XSBooleanValue(Boolean.valueOf(mustUnderstand), false));
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(MustUnderstandBearing.SOAP12_MUST_UNDERSTAND_ATTR_NAME, new XSBooleanValue(Boolean.valueOf(mustUnderstand), false).toString());
        } else {
            throw new IllegalArgumentException("Specified object was neither MustUnderstandBearing nor AttributeExtensible");
        }
    }

    public static boolean getSOAP12MustUnderstandAttribute(@Nonnull XMLObject soapObject) {
        Object value;
        if (soapObject instanceof MustUnderstandBearing && (value = ((MustUnderstandBearing)soapObject).isSOAP12MustUnderstandXSBoolean()) != null) {
            return value.getValue();
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)MustUnderstandBearing.SOAP12_MUST_UNDERSTAND_ATTR_NAME));
            return Objects.equal((Object)"1", (Object)value) || Objects.equal((Object)"true", (Object)value);
        }
        return false;
    }

    public static void addSOAP12RelayAttribute(@Nonnull XMLObject soapObject, boolean relay) {
        if (soapObject instanceof RelayBearing) {
            ((RelayBearing)soapObject).setSOAP12Relay(new XSBooleanValue(Boolean.valueOf(relay), false));
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(RelayBearing.SOAP12_RELAY_ATTR_NAME, new XSBooleanValue(Boolean.valueOf(relay), false).toString());
        } else {
            throw new IllegalArgumentException("Specified object was neither RelayBearing nor AttributeExtensible");
        }
    }

    public static boolean getSOAP12RelayAttribute(@Nonnull XMLObject soapObject) {
        Object value;
        if (soapObject instanceof RelayBearing && (value = ((RelayBearing)soapObject).isSOAP12RelayXSBoolean()) != null) {
            return value.getValue();
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)"relay"));
            return Objects.equal((Object)"1", (Object)value) || Objects.equal((Object)"true", (Object)value);
        }
        return false;
    }

    public static void addSOAP12RoleAttribute(@Nonnull XMLObject soapObject, @Nonnull String role) {
        String value = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)role), (String)"Role cannot be null or empty");
        if (soapObject instanceof RoleBearing) {
            ((RoleBearing)soapObject).setSOAP12Role(value);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(RoleBearing.SOAP12_ROLE_ATTR_NAME, value);
        } else {
            throw new IllegalArgumentException("Specified object was neither RoleBearing nor AttribtueExtensible");
        }
    }

    @Nullable
    public static String getSOAP12RoleAttribute(@Nonnull XMLObject soapObject) {
        String role = null;
        if (soapObject instanceof RoleBearing) {
            role = ((RoleBearing)soapObject).getSOAP12Role();
        }
        if (role == null && soapObject instanceof AttributeExtensibleXMLObject) {
            role = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)"role"));
        }
        return role;
    }

    public static void addHeaderBlock(@Nonnull MessageContext messageContext, @Nonnull XMLObject headerBlock) {
        Constraint.isNotNull((Object)messageContext, (String)"Message context cannot be null");
        SOAP11Context soap11 = (SOAP11Context)messageContext.getSubcontext(SOAP11Context.class, false);
        if (soap11 == null) {
            throw new IllegalArgumentException("Message context did not contain a SOAP Envelope");
        }
        SOAPSupport.addSOAP11HeaderBlock(soap11.getEnvelope(), headerBlock);
    }

    public static void addSOAP11HeaderBlock(@Nonnull Envelope envelope, @Nonnull XMLObject headerBlock) {
        Constraint.isNotNull((Object)envelope, (String)"Envelope cannot be null");
        Constraint.isNotNull((Object)headerBlock, (String)"Header block cannot be null");
        Header envelopeHeader = envelope.getHeader();
        if (envelopeHeader == null) {
            envelopeHeader = (Header)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Header.DEFAULT_ELEMENT_NAME).buildObject(Header.DEFAULT_ELEMENT_NAME);
            envelope.setHeader(envelopeHeader);
        }
        envelopeHeader.getUnknownXMLObjects().add(headerBlock);
    }

    @Nonnull
    public static List<XMLObject> getInboundHeaderBlock(@Nonnull MessageContext messageContext, @Nonnull QName headerName, @Nullable Set<String> targetNodes, boolean isFinalDestination) {
        Constraint.isNotNull((Object)messageContext, (String)"Message context cannot be null");
        SOAP11Context soap11 = (SOAP11Context)messageContext.getSubcontext(SOAP11Context.class, false);
        if (soap11 != null) {
            return SOAPSupport.getSOAP11HeaderBlock(soap11.getEnvelope(), headerName, targetNodes, isFinalDestination);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static List<XMLObject> getSOAP11HeaderBlock(@Nonnull Envelope envelope, @Nonnull QName headerName, @Nullable Set<String> targetNodes, boolean isFinalDestination) {
        Constraint.isNotNull((Object)envelope, (String)"Envelope cannot be null");
        Constraint.isNotNull((Object)headerName, (String)"Header name cannot be null");
        Header envelopeHeader = envelope.getHeader();
        if (envelopeHeader == null) {
            return Collections.emptyList();
        }
        LazyList headers = new LazyList();
        for (XMLObject header : envelopeHeader.getUnknownXMLObjects(headerName)) {
            if (!SOAPSupport.isSOAP11HeaderTargetedToNode(header, targetNodes, isFinalDestination)) continue;
            headers.add((Object)header);
        }
        return headers;
    }

    public static boolean isSOAP11HeaderTargetedToNode(@Nonnull XMLObject header, @Nullable Set<String> nodeActors, boolean isFinalDestination) {
        String headerActor = SOAPSupport.getSOAP11ActorAttribute(header);
        if (headerActor == null) {
            if (isFinalDestination) {
                return true;
            }
        } else {
            if ("http://schemas.xmlsoap.org/soap/actor/next".equals(headerActor)) {
                return true;
            }
            if (nodeActors != null && nodeActors.contains(headerActor)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSOAPMessage(@Nonnull MessageContext<? extends XMLObject> messageContext) {
        Constraint.isNotNull(messageContext, (String)"Message context cannot be null");
        XMLObject inboundMessage = (XMLObject)messageContext.getMessage();
        if (inboundMessage == null) {
            return false;
        }
        return inboundMessage instanceof Envelope;
    }

    public static Fault buildSOAP11Fault(@Nonnull QName faultCode, @Nonnull String faultString, @Nullable String faultActor, @Nullable List<XMLObject> detailChildren, @Nullable Map<QName, String> detailAttributes) {
        Constraint.isNotNull((Object)faultCode, (String)"faultcode cannot be null");
        Constraint.isNotNull((Object)faultString, (String)"faultstring cannot be null");
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        Fault faultObj = (Fault)builderFactory.getBuilder(Fault.DEFAULT_ELEMENT_NAME).buildObject(Fault.DEFAULT_ELEMENT_NAME);
        FaultCode faultCodeObj = (FaultCode)builderFactory.getBuilder(FaultCode.DEFAULT_ELEMENT_NAME).buildObject(FaultCode.DEFAULT_ELEMENT_NAME);
        FaultString faultStringObj = (FaultString)builderFactory.getBuilder(FaultString.DEFAULT_ELEMENT_NAME).buildObject(FaultString.DEFAULT_ELEMENT_NAME);
        faultCodeObj.setValue(faultCode);
        faultObj.setCode(faultCodeObj);
        faultStringObj.setValue(faultString);
        faultObj.setMessage(faultStringObj);
        if (faultActor != null) {
            FaultActor faultActorObj = (FaultActor)builderFactory.getBuilder(FaultActor.DEFAULT_ELEMENT_NAME).buildObject(FaultActor.DEFAULT_ELEMENT_NAME);
            faultActorObj.setValue(faultActor);
            faultObj.setActor(faultActorObj);
        }
        Detail detailObj = null;
        if (detailChildren != null && !detailChildren.isEmpty()) {
            detailObj = (Detail)builderFactory.getBuilder(Detail.DEFAULT_ELEMENT_NAME).buildObject(Detail.DEFAULT_ELEMENT_NAME);
            for (XMLObject xo : Iterables.filter(detailChildren, (Predicate)Predicates.notNull())) {
                detailObj.getUnknownXMLObjects().add(xo);
            }
        }
        if (detailAttributes != null && !detailAttributes.isEmpty()) {
            if (detailObj == null) {
                detailObj = (Detail)builderFactory.getBuilder(Detail.DEFAULT_ELEMENT_NAME).buildObject(Detail.DEFAULT_ELEMENT_NAME);
            }
            for (Map.Entry<QName, String> entry : detailAttributes.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                detailObj.getUnknownAttributes().put(entry.getKey(), entry.getValue());
            }
        }
        if (!(detailObj == null || detailObj.getUnknownXMLObjects().isEmpty() && detailObj.getUnknownAttributes().isEmpty())) {
            faultObj.setDetail(detailObj);
        }
        return faultObj;
    }
}

