/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.PKIXValidationInformationResolver;

public class StaticPKIXValidationInformationResolver
implements PKIXValidationInformationResolver {
    private final List<PKIXValidationInformation> pkixInfo;
    private final Set<String> trustedNames;

    public StaticPKIXValidationInformationResolver(@Nullable List<PKIXValidationInformation> info, @Nullable Set<String> names) {
        this.pkixInfo = info != null ? new ArrayList<PKIXValidationInformation>(info) : Collections.EMPTY_LIST;
        this.trustedNames = names != null ? new HashSet<String>(names) : Collections.EMPTY_SET;
    }

    @Nullable
    public Set<String> resolveTrustedNames(CriteriaSet criteriaSet) throws ResolverException {
        return this.trustedNames;
    }

    public boolean supportsTrustedNameResolution() {
        return true;
    }

    @Nonnull
    public Iterable<PKIXValidationInformation> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        return this.pkixInfo;
    }

    @Nullable
    public PKIXValidationInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        if (!this.pkixInfo.isEmpty()) {
            return this.pkixInfo.get(0);
        }
        return null;
    }
}

