/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicHTTPMetadataResolver
extends AbstractDynamicMetadataResolver {
    public static final String[] DEFAULT_CONTENT_TYPES = new String[]{"application/samlmetadata+xml", "application/xml", "text/xml"};
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicHTTPMetadataResolver.class);
    private HttpClient httpClient;
    private List<String> supportedContentTypes;
    private String supportedContentTypesValue;
    private ResponseHandler<XMLObject> responseHandler;
    private CredentialsProvider credentialsProvider;

    public AbstractDynamicHTTPMetadataResolver(@Nonnull HttpClient client) {
        this(null, client);
    }

    public AbstractDynamicHTTPMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull HttpClient client) {
        super(backgroundTaskTimer);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient may not be null");
        this.responseHandler = new BasicMetadataResponseHandler();
    }

    public void setCredentialsProvider(@Nullable CredentialsProvider provider) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.credentialsProvider = provider;
    }

    public void setBasicCredentials(@Nullable UsernamePasswordCredentials credentials) {
        this.setBasicCredentialsWithScope(credentials, null);
    }

    public void setBasicCredentialsWithScope(@Nullable UsernamePasswordCredentials credentials, @Nullable AuthScope scope) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (credentials != null) {
            AuthScope authScope = scope;
            if (authScope == null) {
                authScope = new AuthScope(AuthScope.ANY_HOST, -1);
            }
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(authScope, (Credentials)credentials);
            this.credentialsProvider = provider;
        } else {
            this.log.debug("Either username or password were null, disabling basic auth");
            this.credentialsProvider = null;
        }
    }

    @NonnullAfterInit
    @NotLive
    @Unmodifiable
    public List<String> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public void setSupportedContentTypes(@Nullable List<String> types) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.supportedContentTypes = types == null ? Collections.emptyList() : Lists.newArrayList((Iterable)Collections2.transform((Collection)StringSupport.normalizeStringCollection(types), (Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String input) {
                return input == null ? null : input.toLowerCase();
            }
        }));
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        this.setBackingStore(this.createNewBackingStore());
        if (this.getSupportedContentTypes() == null) {
            this.setSupportedContentTypes(Arrays.asList(DEFAULT_CONTENT_TYPES));
        }
        if (!this.getSupportedContentTypes().isEmpty()) {
            this.supportedContentTypesValue = StringSupport.listToStringValue(this.getSupportedContentTypes(), (String)", ");
        }
        this.log.debug("Supported content types are: {}", this.getSupportedContentTypes());
    }

    @Override
    protected void doDestroy() {
        this.httpClient = null;
        this.credentialsProvider = null;
        this.supportedContentTypes = null;
        this.supportedContentTypesValue = null;
        super.doDestroy();
    }

    @Override
    @Nullable
    protected XMLObject fetchFromOriginSource(@Nonnull CriteriaSet criteria) throws IOException {
        HttpUriRequest request = this.buildHttpRequest(criteria);
        if (request == null) {
            this.log.debug("Could not build request based on input criteria, unable to query");
            return null;
        }
        HttpClientContext context = this.buildHttpClientContext();
        return (XMLObject)this.httpClient.execute(request, this.responseHandler, (HttpContext)context);
    }

    @Nullable
    protected HttpUriRequest buildHttpRequest(@Nonnull CriteriaSet criteria) {
        String url = this.buildRequestURL(criteria);
        this.log.debug("Built request URL of: {}", (Object)url);
        if (url == null) {
            this.log.debug("Could not construct request URL from input criteria, unable to query");
            return null;
        }
        HttpGet getMethod = new HttpGet(url);
        if (!Strings.isNullOrEmpty((String)this.supportedContentTypesValue)) {
            getMethod.addHeader("Accept", this.supportedContentTypesValue);
        }
        return getMethod;
    }

    @Nullable
    protected abstract String buildRequestURL(@Nonnull CriteriaSet var1);

    protected HttpClientContext buildHttpClientContext() {
        HttpClientContext context = HttpClientContext.create();
        if (this.credentialsProvider != null) {
            context.setCredentialsProvider(this.credentialsProvider);
        }
        return context;
    }

    public class BasicMetadataResponseHandler
    implements ResponseHandler<XMLObject> {
        public XMLObject handleResponse(@Nonnull HttpResponse response) throws ClientProtocolException, IOException {
            int httpStatusCode = response.getStatusLine().getStatusCode();
            if (httpStatusCode == 304) {
                AbstractDynamicHTTPMetadataResolver.this.log.debug("Metadata document from '{}' has not changed since last retrieval");
                return null;
            }
            if (httpStatusCode != 200) {
                AbstractDynamicHTTPMetadataResolver.this.log.warn("Non-ok status code '{}' returned from remote metadata source: {}", (Object)httpStatusCode);
                return null;
            }
            try {
                this.validateHttpResponse(response);
            }
            catch (ResolverException e) {
                AbstractDynamicHTTPMetadataResolver.this.log.error("Problem validating dynamic metadata HTTP response", (Throwable)e);
                return null;
            }
            try {
                InputStream ins = response.getEntity().getContent();
                return AbstractDynamicHTTPMetadataResolver.this.unmarshallMetadata(ins);
            }
            catch (IOException | UnmarshallingException e) {
                AbstractDynamicHTTPMetadataResolver.this.log.error("Error unmarshalling HTTP response stream", e);
                return null;
            }
        }

        protected void validateHttpResponse(@Nonnull HttpResponse response) throws ResolverException {
            Header contentType;
            if (!AbstractDynamicHTTPMetadataResolver.this.getSupportedContentTypes().isEmpty() && (contentType = response.getEntity().getContentType()) != null && contentType.getValue() != null) {
                AbstractDynamicHTTPMetadataResolver.this.log.debug("Saw raw Content-Type from response header '{}'", (Object)contentType.getValue());
                String mimeType = this.getContentTypeMIMEType(contentType.getValue());
                AbstractDynamicHTTPMetadataResolver.this.log.debug("Extracted Content-Type MIME type to evaluate '{}'", (Object)mimeType);
                if (!AbstractDynamicHTTPMetadataResolver.this.getSupportedContentTypes().contains(mimeType)) {
                    throw new ResolverException("HTTP response specified an unsupported Content-Type MIME type: " + mimeType);
                }
            }
        }

        private String getContentTypeMIMEType(String value) {
            String trimmed = StringSupport.trimOrNull((String)value);
            if (trimmed == null) {
                return null;
            }
            if (!trimmed.contains(";")) {
                return trimmed.toLowerCase();
            }
            String typeSubtype = trimmed.split(";")[0];
            return StringSupport.trim((String)typeSubtype).toLowerCase();
        }
    }
}

