/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicHTTPMetadataResolver
extends AbstractDynamicMetadataResolver {
    public static final String[] DEFAULT_CONTENT_TYPES = new String[]{"application/samlmetadata+xml", "application/xml", "text/xml"};
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicHTTPMetadataResolver.class);
    private HttpClient httpClient;
    private List<String> supportedContentTypes;
    private String supportedContentTypesValue;

    public AbstractDynamicHTTPMetadataResolver(@Nonnull HttpClient client) {
        this(null, client);
    }

    public AbstractDynamicHTTPMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull HttpClient client) {
        super(backgroundTaskTimer);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient may not be null");
    }

    @NonnullAfterInit
    @NotLive
    @Unmodifiable
    public List<String> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public void setSupportedContentTypes(@Nullable List<String> types) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.supportedContentTypes = types == null ? Collections.emptyList() : Lists.newArrayList((Iterable)StringSupport.normalizeStringCollection(types));
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        this.setBackingStore(this.createNewBackingStore());
        if (this.getSupportedContentTypes() == null) {
            this.setSupportedContentTypes(Arrays.asList(DEFAULT_CONTENT_TYPES));
        }
        if (!this.getSupportedContentTypes().isEmpty()) {
            this.supportedContentTypesValue = StringSupport.listToStringValue(this.getSupportedContentTypes(), (String)", ");
        }
    }

    @Override
    protected void doDestroy() {
        this.httpClient = null;
        this.supportedContentTypes = null;
        this.supportedContentTypesValue = null;
        super.doDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @NonnullElements
    protected Iterable<EntityDescriptor> fetchByCriteria(@Nonnull CriteriaSet criteria) throws ResolverException {
        String entityID = StringSupport.trimOrNull((String)((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
        Lock writeLock = this.getBackingStore().getManagementData(entityID).getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            List<EntityDescriptor> descriptors = this.lookupEntityID(entityID);
            if (!descriptors.isEmpty()) {
                this.log.debug("Metadata was resolved and stored by another thread while this thread was waiting on the write lock");
                List<EntityDescriptor> list = descriptors;
                return list;
            }
            HttpUriRequest request = this.buildHttpRequest(criteria);
            if (request == null) {
                this.log.debug("Could not build request based on input criteria, unable to query");
                List<EntityDescriptor> list = Collections.emptyList();
                return list;
            }
            HttpResponse response = this.httpClient.execute(request);
            this.processResponse(response, request.getURI(), entityID);
            List<EntityDescriptor> list = this.lookupEntityID(entityID);
            return list;
        }
        catch (IOException e) {
            this.log.error("Error executing HTTP request", (Throwable)e);
            List<EntityDescriptor> list = Collections.emptyList();
            return list;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Nullable
    protected HttpUriRequest buildHttpRequest(@Nonnull CriteriaSet criteria) {
        String url = this.buildRequestURL(criteria);
        this.log.debug("Built request URL of: {}", (Object)url);
        if (url == null) {
            this.log.debug("Could not construct request URL from input criteria, unable to query");
            return null;
        }
        HttpGet getMethod = new HttpGet(url);
        if (!Strings.isNullOrEmpty((String)this.supportedContentTypesValue)) {
            getMethod.addHeader("Accept", this.supportedContentTypesValue);
        }
        return getMethod;
    }

    @Nullable
    protected abstract String buildRequestURL(@Nonnull CriteriaSet var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResponse(@Nonnull HttpResponse response, @Nonnull URI requestURI, @Nonnull String expectedEntityID) throws ResolverException {
        int httpStatusCode = response.getStatusLine().getStatusCode();
        if (httpStatusCode == 304) {
            this.log.debug("Metadata document from '{}' has not changed since last retrieval", (Object)requestURI);
            return;
        }
        if (httpStatusCode != 200) {
            this.log.warn("Non-ok status code '{}' returned from remote metadata source: {}", (Object)httpStatusCode, (Object)requestURI);
            return;
        }
        XMLObject root = null;
        try {
            try {
                this.validateHttpResponse(response, requestURI);
            }
            catch (ResolverException e) {
                this.log.error("Problem validating dynamic metadata HTTP response", (Throwable)e);
                this.closeResponse(response, requestURI);
                return;
            }
            try {
                InputStream ins = response.getEntity().getContent();
                root = this.unmarshallMetadata(ins);
            }
            catch (IOException | UnmarshallingException e) {
                this.log.error("Error unmarshalling HTTP response stream", e);
                this.closeResponse(response, requestURI);
                return;
            }
        }
        finally {
            this.closeResponse(response, requestURI);
        }
        try {
            this.processNewMetadata(root, expectedEntityID);
        }
        catch (FilterException e) {
            this.log.error("Metadata filtering problem processing new metadata", (Throwable)e);
            return;
        }
    }

    protected void closeResponse(@Nonnull HttpResponse response, @Nonnull URI requestURI) {
        if (response instanceof CloseableHttpResponse) {
            try {
                ((CloseableHttpResponse)response).close();
            }
            catch (IOException e) {
                this.log.error("Error closing HTTP response from {}", (Object)requestURI, (Object)e);
            }
        }
    }

    public void validateHttpResponse(@Nonnull HttpResponse response, @Nonnull URI requestURI) throws ResolverException {
        Header contentType;
        if (!this.getSupportedContentTypes().isEmpty() && (contentType = response.getEntity().getContentType()) != null && contentType.getValue() != null && !this.getSupportedContentTypes().contains(contentType.getValue())) {
            throw new ResolverException("HTTP response specified an unsupported Content-Type: " + contentType.getValue());
        }
    }
}

