/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.profile.logic.DefaultNameIDPolicyPredicate;
import org.opensaml.saml.common.profile.logic.MetadataNameIdentifierFormatStrategy;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.profile.SAML2NameIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNameIDToSubjects
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddNameIDToSubjects.class);
    @Nonnull
    private SAMLObjectBuilder<Subject> subjectBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Subject.DEFAULT_ELEMENT_NAME);
    @Nonnull
    private SAMLObjectBuilder<NameID> nameIdBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameID.DEFAULT_ELEMENT_NAME);
    private boolean overwriteExisting = true;
    @Nonnull
    private Function<ProfileRequestContext, AuthnRequest> requestLookupStrategy = Functions.compose((Function)new MessageLookup(AuthnRequest.class), (Function)new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy = Functions.compose((Function)new MessageLookup(Response.class), (Function)new OutboundMessageContextLookup());
    @Nonnull
    private Predicate<ProfileRequestContext> nameIDPolicyPredicate = new DefaultNameIDPolicyPredicate();
    @Nonnull
    private Function<ProfileRequestContext, List<String>> formatLookupStrategy;
    @NonnullAfterInit
    private SAML2NameIDGenerator generator;
    @Nonnull
    @NonnullElements
    private List<String> formats;
    @Nullable
    private String requiredFormat;
    @Nullable
    private AuthnRequest request;
    @Nullable
    private Response response;

    public AddNameIDToSubjects() throws ComponentInitializationException {
        ((DefaultNameIDPolicyPredicate)this.nameIDPolicyPredicate).setRequesterIdLookupStrategy(new RequesterIdFromIssuerFunction());
        ((DefaultNameIDPolicyPredicate)this.nameIDPolicyPredicate).setObjectLookupStrategy(new NameIDPolicyLookupFunction());
        ((DefaultNameIDPolicyPredicate)this.nameIDPolicyPredicate).initialize();
        this.formatLookupStrategy = new MetadataNameIdentifierFormatStrategy();
        this.formats = Collections.emptyList();
    }

    public void setOverwriteExisting(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.overwriteExisting = flag;
    }

    public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public void setNameIDPolicyPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nameIDPolicyPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"NameIDPolicy predicate cannot be null");
    }

    public void setFormatLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.formatLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Format lookup strategy cannot be null");
    }

    public void setNameIDGenerator(@Nullable SAML2NameIDGenerator theGenerator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.generator = (SAML2NameIDGenerator)Constraint.isNotNull((Object)theGenerator, (String)"SAML2NameIDGenerator cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.generator == null) {
            throw new ComponentInitializationException("SAML2NameIDGenerator cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Attempting to add NameID to assertions in outgoing Response", (Object)this.getLogPrefix());
        this.response = (Response)this.responseLookupStrategy.apply((Object)profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No SAML response located in current profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (this.response.getAssertions().isEmpty()) {
            this.log.debug("{} No assertions in response message, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        if (!this.nameIDPolicyPredicate.apply((Object)profileRequestContext)) {
            this.log.debug("{} NameIDPolicy was unacceptable", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidNameIDPolicy");
            return false;
        }
        this.request = (AuthnRequest)this.requestLookupStrategy.apply((Object)profileRequestContext);
        this.requiredFormat = this.getRequiredFormat(profileRequestContext);
        if (this.requiredFormat != null) {
            this.formats = Collections.singletonList(this.requiredFormat);
            this.log.debug("{} Request specified NameID format: {}", (Object)this.getLogPrefix(), (Object)this.requiredFormat);
        } else {
            this.formats = (List)this.formatLookupStrategy.apply((Object)profileRequestContext);
            if (this.formats == null || this.formats.isEmpty()) {
                this.log.debug("{} No candidate NameID formats, nothing to do", (Object)this.getLogPrefix());
                return false;
            }
            this.log.debug("{} Candidate NameID formats: {}", (Object)this.getLogPrefix(), this.formats);
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        NameID nameId = this.generateNameID(profileRequestContext);
        if (nameId == null) {
            if (this.requiredFormat != null) {
                this.log.warn("{} Request specified use of an unsupportable identifier format: {}", (Object)this.getLogPrefix(), (Object)this.requiredFormat);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidNameIDPolicy");
            } else {
                this.log.debug("{} Unable to generate a NameID, leaving empty", (Object)this.getLogPrefix());
            }
            return;
        }
        int count = 0;
        for (Assertion assertion : this.response.getAssertions()) {
            Subject subject = this.getAssertionSubject(assertion);
            NameID existing = subject.getNameID();
            if (existing == null || this.overwriteExisting) {
                subject.setNameID(count > 0 ? this.cloneNameID(nameId) : nameId);
            }
            ++count;
        }
        if (count > 0) {
            this.log.debug("{} Added NameID to {} assertion subject(s)", (Object)this.getLogPrefix(), (Object)count);
        }
    }

    @Nullable
    private String getRequiredFormat(@Nonnull ProfileRequestContext profileRequestContext) {
        String format;
        NameIDPolicy policy;
        if (!(this.request == null || (policy = this.request.getNameIDPolicy()) == null || Strings.isNullOrEmpty((String)(format = policy.getFormat())) || "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equals(format) || "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equals(format))) {
            return format;
        }
        return null;
    }

    @Nullable
    private NameID generateNameID(@Nonnull ProfileRequestContext profileRequestContext) {
        for (String format : this.formats) {
            this.log.debug("{} Trying to generate NameID with Format {}", (Object)this.getLogPrefix(), (Object)format);
            try {
                NameID nameId = this.generator.generate(profileRequestContext, format);
                if (nameId == null) continue;
                this.log.debug("{} Successfully generated NameID with Format {}", (Object)this.getLogPrefix(), (Object)format);
                return nameId;
            }
            catch (SAMLException e) {
                this.log.error(this.getLogPrefix() + " Error while generating NameID", (Throwable)e);
            }
        }
        return null;
    }

    @Nonnull
    private Subject getAssertionSubject(@Nonnull Assertion assertion) {
        if (assertion.getSubject() != null) {
            return assertion.getSubject();
        }
        Subject subject = (Subject)this.subjectBuilder.buildObject();
        assertion.setSubject(subject);
        return subject;
    }

    @Nonnull
    private NameID cloneNameID(@Nonnull NameID nameId) {
        NameID clone = (NameID)this.nameIdBuilder.buildObject();
        clone.setFormat(nameId.getFormat());
        clone.setNameQualifier(nameId.getNameQualifier());
        clone.setSPNameQualifier(nameId.getSPNameQualifier());
        clone.setSPProvidedID(nameId.getSPProvidedID());
        clone.setValue(nameId.getValue());
        return clone;
    }

    public static class RequesterIdFromIssuerFunction
    implements Function<ProfileRequestContext, String> {
        @Nonnull
        private Function<ProfileRequestContext, RequestAbstractType> requestLookupStrategy = Functions.compose((Function)new MessageLookup(RequestAbstractType.class), (Function)new InboundMessageContextLookup());

        public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, RequestAbstractType> strategy) {
            this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
        }

        @Nullable
        public String apply(@Nullable ProfileRequestContext profileRequestContext) {
            Issuer issuer;
            RequestAbstractType request = (RequestAbstractType)this.requestLookupStrategy.apply((Object)profileRequestContext);
            if (request != null && request.getIssuer() != null && ((issuer = request.getIssuer()).getFormat() == null || "urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(issuer.getFormat()))) {
                return issuer.getValue();
            }
            return null;
        }
    }

    public static class NameIDPolicyLookupFunction
    implements Function<ProfileRequestContext, SAMLObject> {
        @Nonnull
        private Function<ProfileRequestContext, AuthnRequest> requestLookupStrategy = Functions.compose((Function)new MessageLookup(AuthnRequest.class), (Function)new InboundMessageContextLookup());

        public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
            this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
        }

        @Nullable
        public SAMLObject apply(@Nullable ProfileRequestContext profileRequestContext) {
            AuthnRequest request = (AuthnRequest)this.requestLookupStrategy.apply((Object)profileRequestContext);
            if (request != null) {
                return request.getNameIDPolicy();
            }
            return null;
        }
    }
}

